% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_psi_n_controlled_errors.R
\name{popsize_simul}
\alias{popsize_simul}
\title{Estimate the total population size and capture probabilities using perturbed true nuisance functions.}
\usage{
popsize_simul(
  data,
  n,
  K = 2,
  nfolds = 5,
  pi1,
  pi2,
  omega,
  alpha,
  margin = 0.005,
  iter = 100,
  twolist = TRUE
)
}
\arguments{
\item{data}{The data frame in capture-recapture format for which total population is to be estimated.
The first K columns are the capture history indicators for the K lists. The remaining columns are covariates in numeric format.}

\item{n}{The true population size. Required to calculate the added error.}

\item{K}{The number of lists in the data. typically the first \code{K} rows of data.}

\item{nfolds}{The number of folds to be used for cross fitting.}

\item{pi1}{The function to calculate the conditional capture probabilities of list 1 using covariates.}

\item{pi2}{The function to calculate the conditional capture probabilities of list 2 using covariates.}

\item{omega}{The standard deviation from zero of the added error.}

\item{alpha}{The rate of convergence. Takes values in (0, 1].}

\item{margin}{The minimum value the estimates can attain to bound them away from zero.}

\item{iter}{An integer denoting the maximum number of iterations allowed for targeted maximum likelihood method.}

\item{twolist}{The logical value of whether targeted maximum likelihood algorithm fits only two modes when K = 2.}
}
\value{
A list of estimates containing the following components:
\item{psi}{  A matrix of the estimated capture probability for each list pair, model and method combination. In the absence of covariates, the column represents the standard plug-in estimate.
The rows represent the list pair which is assumed to be independent conditioned on the covariates.
The columns represent the model and method combinations (PI = plug-in, DR = bias-corrected, TMLE = targeted maximum likelihood estimate)indicated in the columns.}
\item{sigma2}{  A matrix of the efficiency bound \code{sigma^2} in the same format as \code{psi}.}
\item{n}{  A matrix of the estimated population size n in the same format as \code{psi}.}
\item{varn}{  A matrix of the variance for population size estimate in the same format as \code{psi}.}
\item{N}{  The number of data points used in the estimation after removing rows with missing data.}
}
\description{
Estimate the total population size and capture probabilities using perturbed true nuisance functions.
}
\examples{
simulresult = simuldata(n = 2000, l = 2)
data = simulresult$data

psin_estimate = popsize_simul(data = data,
      pi1 = simulresult$pi1, pi2 = simulresult$pi2,
      alpha = 0.25, omega = 1)

}
\references{
Das, M., Kennedy, E. H., & Jewell, N.P. (2021). Doubly robust capture-recapture methods for estimating population size. \emph{arXiv preprint} \emph{arXiv:2104.14091}
}
