% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_funs.R
\name{enumerate_items}
\alias{enumerate_items}
\title{Enumerates the elements of a vector}
\usage{
enumerate_items(
  x,
  type,
  verb = FALSE,
  s = FALSE,
  past = FALSE,
  or = FALSE,
  start_verb = FALSE,
  quote = FALSE,
  enum = FALSE,
  other = "",
  nmax = 7
)
}
\arguments{
\item{x}{A vector.}

\item{type}{A single character string, optional. If this argument is used, it supersedes all other arguments. It compactly provides the arguments of the function: it must be like \code{"arg1.arg2.arg3"}, i.e. a list of arguments separated by a point. The arguments are: "s" (to add a starting s if \code{length(x)>1}), "or" (to have "or" instead of "and"), "start" (to place the verb at the start instead of in the end), "quote" (to quote the elements of the vector), "enum" (to make an enumeration), "past" (to put the verb in past tense), a verb (i.e. anything different from the previous codes is a verb). Use \code{other(XX)} to set the argument \code{other} to \code{XX}. See details and examples.}

\item{verb}{Default is \code{FALSE}. If provided, a verb is added at the end of the string, at the appropriate form. You add the verb at the start of the string using the argument \code{start_verb}. Valid verbs are: "be", "is", "has", "have", and any other verb with a regular form.}

\item{s}{Logical, default is \code{FALSE}. If \code{TRUE} a \code{s} is added at the beginning of the string if the length of \code{x} is greater than one.}

\item{past}{Logical, default is \code{FALSE}. If \code{TRUE} the verb is put at the past tense.}

\item{or}{Logical, default is \code{FALSE}. If \code{TRUE} the two last items of the vector are separated by "or" instead of "and".}

\item{start_verb}{Logical, default is \code{FALSE}. If \code{TRUE} the verb is placed at the beginning of the string instead of the end.}

\item{quote}{Logical, default is \code{FALSE}. If \code{TRUE} all items are put in between single quotes.}

\item{enum}{Logical, default is \code{FALSE}. If provided, an enumeration of the items of \code{x} is created. The possible values are "i", "I", "1", "a" and "A". Example: \code{x = c(5, 3, 12)}, \code{enum = "i"} will lead to "i) 5, ii) 3, and iii) 12".}

\item{other}{Character scalar, defaults to the empty string: \code{""}. If there are more than \code{nmax} elements, then the character string will end with \code{"and XX others"} with \code{XX} the number of remaining items. Use this argument to change what is between the \code{and} and the \code{XX}. E.g. if \code{other = "any of"}, then you would get \code{"... and any of 15 others"} instead of \code{"... and 15 others"}.}

\item{nmax}{Integer, default is 7. If \code{x} contains more than \code{nmax} items, then these items are grouped into an "other" group.}
}
\value{
It returns a character string of lentgh one.
}
\description{
Transforms a vector into a single character string enumerating the values of the vector. Many options exist to customize the result. The main purpose of this function is to ease the creation of user-level messages.
}
\section{The argument \code{type}}{

The argument \code{type} is a "super argument". When provided, it supersedes all other arguments. It offers a compact way to give the arguments to the function.

Its sytax is as follows: \code{"arg1.arg2.arg2"}, where \code{argX} is an argument code. The codes are "s", "past", "or", "start", "quote", "enum" -- they refer to the function arguments. If you want to add a verb, since it can have a free-form, it is deduced as the argument not equal to the previous codes. For example, if you have \code{type = "s.contain"}, this is identical to calling the function with \code{s = TRUE} and \code{verb = "contain"}.

A note on \code{enum}. The argument \code{enum} can be equal to "i", "I", "a", "A" or "1". When you include it in \code{type}, by default "i" is used. If you want another one, add it in the code. For example \code{type = "is.enum a.past"} is identical to calling the function with \code{verb = "is"}, \code{past = TRUE} and \code{enum = "a"}.
}

\examples{

# Let's say you write an error/information message to the user
# I just use the "type" argument but you can obtain the
#  same results by using regular arguments

x = c("x1", "height", "width")
message("The variable", enumerate_items(x, "s.is"), " not in the data set.")
# Now just the first item
message("The variable", enumerate_items(x[1], "s.is"), " not in the data set.")

# Past
message("The variable", enumerate_items(x, "s.is.past"), " not found.")
message("The variable", enumerate_items(x[1], "s.is.past"), " not found.")

# Verb first
message("The problematic variable", enumerate_items(x, "s.is.start.quote"), ".")
message("The problematic variable", enumerate_items(x[1], "s.is.start.quote"), ".")

# covid times
todo = c("wash your hands", "stay home", "code")
message("You should: ", enumerate_items(todo[c(1, 1, 2, 3)], "enum 1"), "!")
message("You should: ", enumerate_items(todo, "enum.or"), "?")


}
\author{
Laurent Berge
}
