% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{dreamerplot}
\alias{dreamerplot}
\alias{plot.dreamer}
\alias{plot.dreamer_bma}
\title{Posterior Plot of Bayesian Model Averaging}
\usage{
\method{plot}{dreamer}(
  x,
  doses = attr(x, "doses"),
  times = NULL,
  probs = c(0.025, 0.975),
  data = NULL,
  n_smooth = 50,
  predictive = 0,
  width = bar_width(doses),
  reference_dose = NULL,
  ...
)

\method{plot}{dreamer_bma}(
  x,
  doses = x$doses,
  times = x$times,
  probs = c(0.025, 0.975),
  data = NULL,
  n_smooth = 200,
  predictive = 0,
  width = bar_width(doses),
  reference_dose = NULL,
  ...
)
}
\arguments{
\item{x}{output from a call to \code{\link{dreamer_mcmc}}.}

\item{doses}{a vector of doses at which to plot the dose response curve.}

\item{times}{a vector of the times at which to plot the posterior (for
longitudinal models only).}

\item{probs}{quantiles of the posterior to be calculated.}

\item{data}{a dataframe with column names of "dose" and "response" for
individual patient data.  Optional columns "n" and "sample_var" can
be specified if aggregate data is supplied, but it is recommended that
patient-level data be supplied where possible for continuous models, as the
posterior weights differ if aggregated data is used.
For aggregated continuous
data, "response" should be the average of "n" subjects with a sample
variance of "sample_var".  For aggregated binary data, "response" should
be the number of successes, "n" should be the total number of subjects
(the "sample_var" column is irrelevant in binary cases and is ignored).}

\item{n_smooth}{the number of points to calculate the smooth dose response
interpolation.  Must be sufficiently high to accurately depict the
dose response curve.}

\item{predictive}{the size of sample for which to plot posterior predictive
intervals for the mean.}

\item{width}{the width of the error bars.}

\item{reference_dose}{the dose at which to adjust the posterior plot.
Specifying
a dose returns the plot of pr(trt_dose - trt_{reference_dose} | data).}

\item{...}{model definitions created using the model creation functions
in \link[dreamer]{model}.  If arguments are named, the names are
retained in the return values.}
}
\value{
Returns the ggplot object.
}
\description{
Plots the posterior mean and quantiles over the dose range and
plots error bars at the observed doses. If the \code{data} argument is
specified, the observed means at each dose are also plotted.

plot posterior from Bayesian model averaging.
}
\examples{
set.seed(888)
data <- dreamer_data_linear(
  n_cohorts = c(20, 20, 20),
  dose = c(0, 3, 10),
  b1 = 1,
  b2 = 3,
  sigma = 5
)

# Bayesian model averaging
output <- dreamer_mcmc(
 data = data,
 n_adapt = 1e3,
 n_burn = 1e3,
 n_iter = 1e4,
 n_chains = 2,
 silent = FALSE,
 mod_linear = model_linear(
   mu_b1 = 0,
   sigma_b1 = 1,
   mu_b2 = 0,
   sigma_b2 = 1,
   shape = 1,
   rate = .001,
   w_prior = 1 / 2
 ),
 mod_quad = model_quad(
   mu_b1 = 0,
   sigma_b1 = 1,
   mu_b2 = 0,
   sigma_b2 = 1,
   mu_b3 = 0,
   sigma_b3 = 1,
   shape = 1,
   rate = .001,
   w_prior = 1 / 2
 )
)

plot(output)

\dontrun{
# with data
plot(output, data = data)

# predictive distribution
plot(output, data = data, predictive = 1)

# single model
plot(output$mod_linear)
}
}
