% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{drake_cancelled}
\alias{drake_cancelled}
\title{List cancelled targets.
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}}
\usage{
drake_cancelled(cache = drake::drake_cache(path = path), path = NULL)
}
\arguments{
\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{path}{Path to a \code{drake} cache
(usually a hidden \verb{.drake/} folder) or \code{NULL}.}
}
\value{
A character vector of target names.
}
\description{
List the targets that were cancelled in the current or
previous call to \code{\link[=make]{make()}} using \code{\link[=cancel]{cancel()}} or \code{\link[=cancel_if]{cancel_if()}}.
}
\examples{
\dontrun{
isolate_example("contain side effects", {
plan <- drake_plan(x = 1, y = cancel_if(x > 0))
make(plan)
drake_cancelled()
})
}
}
\seealso{
\code{\link[=drake_running]{drake_running()}}, \code{\link[=drake_failed]{drake_failed()}}, \code{\link[=make]{make()}}
}
