% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_plan_helpers.R
\name{trigger}
\alias{trigger}
\title{Customize the decision rules for rebuilding targets
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}}
\usage{
trigger(
  command = TRUE,
  depend = TRUE,
  file = TRUE,
  seed = TRUE,
  format = TRUE,
  condition = FALSE,
  change = NULL,
  mode = c("whitelist", "blacklist", "condition")
)
}
\arguments{
\item{command}{Logical, whether to rebuild the target if the
\code{\link[=drake_plan]{drake_plan()}} command changes.}

\item{depend}{Logical, whether to rebuild if a
non-file dependency changes.}

\item{file}{Logical, whether to rebuild the target
if a \code{\link[=file_in]{file_in()}}/\code{\link[=file_out]{file_out()}}/\code{\link[=knitr_in]{knitr_in()}} file changes.
Also applies to external data tracked with
\code{target(format = "file")}.}

\item{seed}{Logical, whether to rebuild the target
if the seed changes. Only makes a difference if you set
a custom \code{seed} column in your \code{\link[=drake_plan]{drake_plan()}} at some point
in your workflow.}

\item{format}{Logical, whether to rebuild the target if the
choice of specialized data format changes: for example,
if you use \code{target(format = "qs")} one instance and
\code{target(format = "fst")} the next. See
\url{https://books.ropensci.org/drake/plans.html#special-data-formats-for-targets} # nolint
for details on formats.}

\item{condition}{R code (expression or language object)
that returns a logical. The target will rebuild
if the code evaluates to \code{TRUE}.}

\item{change}{R code (expression or language object)
that returns any value. The target will rebuild
if that value is different from last time
or not already cached.}

\item{mode}{A character scalar equal to \code{"whitelist"} (default) or
\code{"blacklist"} or \code{"condition"}. With the \code{mode} argument, you can choose
how the \code{condition} trigger factors into the decision to build
or skip the target. Here are the options.
\itemize{
\item \code{"whitelist"} (default): we \emph{rebuild} the target whenever \code{condition}
evaluates to \code{TRUE}. Otherwise, we defer to the other triggers.
This behavior is the same as the decision rule described in the
"Details" section of this help file.
\item \code{"blacklist"}: we \emph{skip} the target whenever \code{condition} evaluates
to \code{FALSE}. Otherwise, we defer to the other triggers.
\item \code{"condition"}: here, the \code{condition} trigger is the only decider,
and we ignore all the other triggers. We \emph{rebuild} target whenever
\code{condition} evaluates to \code{TRUE} and \emph{skip} it whenever \code{condition}
evaluates to \code{FALSE}.
}}
}
\value{
A list of trigger specification details that
\code{drake} processes internally when it comes time to decide
whether to build the target.
}
\description{
Use this function inside a target's command
in your \code{\link[=drake_plan]{drake_plan()}} or the \code{trigger} argument to
\code{\link[=make]{make()}} or \code{\link[=drake_config]{drake_config()}}.
For details, see the chapter on triggers
in the user manual:
\url{https://books.ropensci.org/drake/triggers.html}
}
\details{
A target always builds if it has not been built before.
Triggers allow you to customize the conditions
under which a pre-existing target \emph{re}builds.
By default, the target will rebuild if and only if:
\itemize{
\item Any of \code{command}, \code{depend}, or \code{file} is \code{TRUE}, or
\item \code{condition} evaluates to \code{TRUE}, or
\item \code{change} evaluates to a value different from last time.
The above steps correspond to the "whitelist" decision rule.
You can select other decision rules with the \code{mode} argument
described in this help file.
On another note, there may be a slight efficiency loss
if you set complex triggers
for \code{change} and/or \code{condition} because
\code{drake} needs to load any required dependencies
into memory before evaluating these triggers.
}
}
\examples{
# A trigger is just a set of decision rules
# to decide whether to build a target.
trigger()
# This trigger will build a target on Tuesdays
# and when the value of an online dataset changes.
trigger(condition = today() == "Tuesday", change = get_online_dataset())
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
# You can use a global trigger argument:
# for example, to always run everything.
make(my_plan, trigger = trigger(condition = TRUE))
make(my_plan, trigger = trigger(condition = TRUE))
# You can also define specific triggers for each target.
plan <- drake_plan(
  x = sample.int(15),
  y = target(
    command = x + 1,
    trigger = trigger(depend = FALSE)
  )
)
# Now, when x changes, y will not.
make(plan)
make(plan)
plan$command[1] <- "sample.int(16)" # change x
make(plan)
}
})
}
}
\seealso{
\code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
