% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Makefile.R
\name{default_Makefile_args}
\alias{default_Makefile_args}
\title{Return the default value of the
\code{args} argument to \code{\link[=make]{make()}}.}
\usage{
default_Makefile_args(jobs, verbose)
}
\arguments{
\item{jobs}{number of jobs}

\item{verbose}{logical or numeric, control printing to the console.
Use \code{pkgconfig} to set the default value of \code{verbose}
for your R session:
for example, \code{pkgconfig::set_config("drake::verbose" = 2)}.
\itemize{
\item \code{0} or \code{FALSE}: print nothing.
\item \code{1} or \code{TRUE}: print only targets to build.
\item \code{2}: also print checks and cache info.
\item \code{3}: also print any potentially missing items.
\item \code{4}: also print imports and writes to the cache.
}}
}
\value{
\code{args} for \code{system2(command, args)}
}
\description{
For \code{make(..., parallelism = "Makefile")},
this function configures the default
arguments to \code{\link[=system2]{system2()}}.
It is an internal function, and most users do not need to
worry about it.
}
\examples{
default_Makefile_args(jobs = 2, verbose = FALSE)
default_Makefile_args(jobs = 4, verbose = TRUE)
}
