% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wildcards.R
\name{plan_analyses}
\alias{plan_analyses}
\title{Generate a workflow plan data frame to
analyze multiple datasets using multiple methods of analysis.}
\usage{
plan_analyses(plan, datasets)
}
\arguments{
\item{plan}{workflow plan data frame of analysis methods.
The commands in the \code{command} column must
have the \code{dataset__} wildcard where the datasets go.
For example, one command could be \code{lm(dataset__)}. Then,
the commands in the output will include \code{lm(your_dataset_1)},
\code{lm(your_dataset_2)}, etc.}

\item{datasets}{workflow plan data frame with instructions
to make the datasets.}
}
\value{
An evaluated workflow plan data frame of analysis targets.
}
\description{
Uses wildcards to create a new
workflow plan data frame from a template data frame.
}
\examples{
# Create the piece of the workflow plan for the datasets.
datasets <- drake_plan(
  small = simulate(5),
  large = simulate(50))
# Create a template for the analysis methods.
methods <- drake_plan(
  regression1 = reg1(dataset__),
  regression2 = reg2(dataset__))
# Evaluate the wildcards to create the part of the workflow plan
# encoding the analyses of the datasets.
ans <- plan_analyses(methods, datasets = datasets)
ans
# For the final workflow plan, row bind the pieces together.
my_plan <- rbind(datasets, ans)
my_plan
}
\seealso{
drake_plan, map_plan, reduce_by, gather_by, reduce_plan,
gather_plan, evaluate_plan, expand_plan, plan_summaries
}
