% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triggers.R
\name{triggers}
\alias{triggers}
\title{List the available drake triggers.}
\usage{
triggers()
}
\value{
A character vector with the names of the available triggers.
}
\description{
Triggers are target-level rules
that tell \code{\link[=make]{make()}} how to know if a target
is outdated or up to date.
}
\details{
By default, \code{make()}
builds targets that need updating and
skips over the ones that are already up to date.
In other words, a change in a dependency, workflow plan command,
or file, or the lack of the target itself,
\emph{triggers} the build process for the target.
You can relax this behavior by choosing a trigger for each target.
Set the trigger for each target with a \code{"trigger"}
column in your workflow plan data frame. The \code{triggers()}
function lists the available triggers:

\itemize{
\item{'any'}{:
Build the target if any of the other triggers activate (default).
}

\item{'command'}{:
Build if the workflow plan command has changed since last
time the target was built. Also built if \code{missing} is triggered.
}

\item{'depends'}{:
Build if any of the target's dependencies
has changed since the last \code{\link[=make]{make()}}.
Also build if \code{missing} is triggered.
}

\item{'file'}{:
Build if the target is a file and
that output file is either missing or corrupted.
Also build if \code{missing} is triggered.
}

\item{'missing'}{:
Build if the target itself is missing. Always applies.
}
}
}
\examples{
triggers()
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Load drake's canonical example.
my_plan[["trigger"]] <- "command"
# You can have different triggers for different targets.
my_plan[["trigger"]][1] <- "file"
make(my_plan) # Run the project, build the targets.
# Change an imported dependency function.
reg2 <- function(d) {
  d$x3 <- d$x ^ 3
  lm(y ~ x3, data = d)
}
# Nothing changes! To react to `reg2`, you would need the
# "any" or "depends" trigger.
make(my_plan)
# You can use a global trigger if your workflow plan
# does not have a 'trigger' column.
my_plan[["trigger"]] <- NULL # Would override the global trigger.
make(my_plan, trigger = "missing") # Just build missing targets.
})
}
}
\seealso{
\code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
