% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_runtime.R
\name{rate_limiting_times}
\alias{rate_limiting_times}
\title{Return a data frame of elapsed build times of
the rate-limiting targets of a drake project.}
\usage{
rate_limiting_times(config = drake::read_drake_config(), targets = NULL,
  from_scratch = FALSE, targets_only = FALSE, future_jobs = 1,
  digits = 3)
}
\arguments{
\item{config}{option internal runtime parameter list of
\code{\link{make}(...)},
produced by both \code{\link[=make]{make()}} and
\code{\link[=drake_config]{drake_config()}}.}

\item{targets}{Character vector, names of targets.
Find the rate-limiting times for building these targets
plus dependencies.
Defaults to all targets.}

\item{from_scratch}{logical, whether to assume
next hypothetical call to \code{\link[=make]{make()}}
is a build from scratch (after \code{\link[=clean]{clean()}}).}

\item{targets_only}{logical, whether to factor in just the
targets or use times from everything, including the imports.}

\item{future_jobs}{hypothetical number of jobs
assumed for the predicted runtime.
assuming this number of jobs.}

\item{digits}{number of digits for rounding the times.}
}
\value{
A data frame of times of the worst-case scenario
rate-limiting targets in each parallelizable stage.
}
\description{
This function produces a conservative
estimate for \code{\link[=predict_runtime]{predict_runtime()}}
for when parallel computing is used in \code{\link[=make]{make()}}.
This feature is experimental.
The accuracy, precision, and utility of these supposedly
rate-limiting times has not been confirmed by rigorous
performance studies.
}
\details{
The \code{stage} column of the returned data frame
is an index that denotes a parallelizable stage.
Within each stage during \code{\link[=make]{make()}},
the targets are divided among the available jobs.
For \code{rate_limiting_times()},
we assume the targets are divided evenly among the jobs
and one job gets all the slowest targets.
The build times of this hypothetical pessimistic job
are returned for each stage. \cr

By default \code{from_scratch} is \code{FALSE}. That way,
\code{rate_limiting_times()} takes into account that some
targets are already up to date, meaning their elapsed
build times will be instant during the next \code{\link[=make]{make()}}.

For the results to make sense, the previous build times
of all targets need to be available (automatically cached
by \code{\link[=make]{make()}}). Otherwise, \code{rate_limiting_times()}
will warn you and tell you which targets have missing times.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
config <- make(my_plan) # Run the project, build the targets.
rate_limiting_times(config) # Everything is up to date.
# Assume everything runs from scratch with 1 job.
rate_limiting_times(config, from_scratch  = TRUE, digits = 4)
# With 2 jobs, some of the targets are not rate-limiting.
rate_limiting_times(
  config,
  future_jobs = 2,
  from_scratch = TRUE,
  digits = 4
)
# Find the rate-limiting times of just building targets
# "small" and "large".
rate_limiting_times(
  config,
  targets = c("small", "large"),
  from_scratch = TRUE,
  digits = 4
)
})
}

}
\seealso{
\code{\link[=predict_runtime]{predict_runtime()}},
\code{\link[=build_times]{build_times()}}
\code{\link[=make]{make()}}
}
