% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe.R
\name{Makefile_recipe}
\alias{Makefile_recipe}
\title{For \code{\link{make}(..., parallelism = "Makefile")},
see what your \code{Makefile} recipes
will look like in advance.}
\usage{
Makefile_recipe(recipe_command = drake::default_recipe_command(),
  target = "your_target", cache_path = drake::default_cache_path())
}
\arguments{
\item{recipe_command}{The Makefile recipe command.
See \code{\link[=default_recipe_command]{default_recipe_command()}}.}

\item{target}{character scalar, name of your target}

\item{cache_path}{path to the drake cache.
In practice, this defaults to the hidden \code{.drake/} folder,
but this can be customized. In the Makefile, the drake cache
is coded with the Unix variable \code{DRAKE_CACHE} and then dereferenced
with \code{$(DRAKE_CACHE)}. To simplify things for users who may
be unfamiliar with Unix variables, the \code{recipe()} function
just shows the literal path to the cache.}
}
\value{
A character scalar with a Makefile recipe.
}
\description{
Relevant to \code{"Makefile"} parallelism only.
}
\details{
Makefile recipes to build targets are customizable.
Use the \code{Makefile_recipe()} function to show and tweak
Makefile recipes in advance, and see
\code{\link[=default_recipe_command]{default_recipe_command()}} and
\code{\link[=r_recipe_wildcard]{r_recipe_wildcard()}} for more clues.
The default recipe is \code{Rscript -e 'R_RECIPE'}, where
\code{R_RECIPE} is the wildcard for the recipe in R for making the target.
In writing the Makefile, \code{R_RECIPE} is replaced with something like
\code{drake::mk("name_of_target", "path_to_cache")}.
So when you call
\code{make(..., parallelism = "Makefile", recipe_command = "R -e 'R_RECIPE' -q")}, # nolint
from within R, the \code{Makefile} builds each target
with the \code{Makefile} recipe,
\code{R -e 'drake::mk("this_target", "path_to_cache")' -q}.
But since \code{R -q -e} fails on Windows,
so the default \code{recipe_command} argument is
\code{"Rscript -e 'R_RECIPE'"}
(equivalently just \code{"Rscript -e"}),
so the default \code{Makefile} recipe for each target is
\code{Rscript -e 'drake::mk("this_target", "path_to_cache")'}.
}
\examples{
# Only relevant for "Makefile" parallelism.
# Show an example Makefile recipe.
Makefile_recipe(cache_path = "path") # `cache_path` has a reliable default.
# Customize your Makefile recipe.
Makefile_recipe(
  target = "this_target",
  recipe_command = "R -e 'R_RECIPE' -q",
  cache_path = "custom_cache"
)
default_recipe_command() # "Rscript -e 'R_RECIPE'" # nolint
r_recipe_wildcard() # "R_RECIPE"
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
# Look at the Makefile generated by the following.
# make(my_plan, paralleliem = "Makefile") # Requires Rtools on Windows. # nolint
# Generates a Makefile with "R -q -e" rather than
# "Rscript -e".
# Be aware the R -q -e fails on Windows.
# make(my_plan, parallelism = "Makefile", jobs = 2, # nolint
#   recipe_command = "R -q -e") # nolint
# Same thing:
clean() # Start from scratch.
# make(my_plan, parallelism = "Makefile", jobs = 2, # nolint
#   recipe_command = "R -q -e 'R_RECIPE'") # nolint
clean() # Start from scratch.
# make(my_plan, parallelism = "Makefile", jobs = 2, # nolint
#   recipe_command = "R -e 'R_RECIPE' -q") # nolint
})
}
}
\seealso{
\code{\link[=default_recipe_command]{default_recipe_command()}},
\code{\link[=r_recipe_wildcard]{r_recipe_wildcard()}}, \code{\link[=make]{make()}}
}
