% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check}
\alias{check}
\title{Function \code{check}}
\usage{
check(plan = workplan(), targets = drake::possible_targets(plan),
  envir = parent.frame(), cache = drake::get_cache(verbose = verbose),
  verbose = TRUE)
}
\arguments{
\item{plan}{workflow plan data frame, possibly from
\code{\link{workplan}()}.}

\item{targets}{character vector of targets to make}

\item{envir}{environment containing user-defined functions}

\item{cache}{optional drake cache. See \code{\link{new_cache}()}}

\item{verbose}{logical, whether to log progress to the console.}
}
\value{
invisibly return \code{plan}
}
\description{
Check a workflow plan, etc. for obvious
errors such as circular dependencies and
missing input files.
}
\examples{
\dontrun{
load_basic_example()
check(my_plan)
unlink('report.Rmd')
check(my_plan)
}
}
\seealso{
\code{ink{workplan}}, \code{\link{make}}
}
