fix_deprecated_plan_names = function(plan){
  if(any(colnames(plan) %in% c("output", "code")))
    warning("Drake is no longer using \"output\" or \"code\" ",
      "for column names in workflow plan data frames. Use \"target\" ",
      "and \"command\" instead.")
  colnames(plan) = gsub("^output$", "target", colnames(plan)) %>%
    gsub(pattern = "^code$", replacement = "command")
  as.data.frame(plan, stringsAsFactors = FALSE)
}

#' @title Deprecated function \code{prune}
#' @description Use \code{\link{clean}()} instead
#' @seealso \code{\link{clean}}, \code{\link{make}}
#' @export
#' @param plan workflow plan data frame, as generated by 
#' \code{\link{plan}}.
#' @examples 
#' \dontrun{
#' load_basic_example()
#' make(my_plan)
#' cached()
#' prune(my_plan[1:3,])
#' cached()
#' make(my_plan)
#' clean(destroy = TRUE)
#' }
prune = function(plan){
  .Deprecated("clean", package = "drake",
    msg = "prune() is deprecated. Use clean() instead.")
  clean(list = setdiff(built(), possible_targets(plan)))
}

#' @title Deprecated function \code{status}
#' @description Use \code{\link{progress}()} instead.
#' Gets the build progress (overall or individual targets)
#' of the last call to \code{\link{make}()}. 
#' Objects that drake imported, built, or attempted
#' to build are listed as \code{"finished"} or \code{"in progress"}. 
#' Skipped objects are not listed.
#' @seealso \code{\link{progress}},
#' \code{\link{built}}, \code{\link{imported}},
#' \code{\link{readd}}, \code{\link{plan}}, \code{\link{make}}
#' @export
#' @return Either the build progress of each target given (from the last
#' call to \code{\link{make}()} or \code{\link{make}()}), or if no 
#' targets are specified, a data frame containing the build progress
#' of the last session. 
#' In the latter case, only finished targets are listed.
#' @return Either a named logical indicating whether the given
#' targets or cached or a character vector listing all cached
#' items, depending on whether any targets are specified
#' @param ... objects to load from the cache, as names (unquoted)
#' or character strings (quoted). Similar to \code{...} in
#' \code{\link{remove}(...)}.
#' @param list character vector naming objects to be loaded from the
#' cache. Similar to the \code{list} argument of \code{\link{remove}()}.
#' @param no_imported_objects logical, whether to only return information
#' about imported files and targets with commands (i.e. whether to ignore 
#' imported objects that are not files).
#' @param imported_files_only logical, deprecated. Same as \code{no_imported_objects}.
#' Use the \code{no_imported_objects} argument instead.
#' @param path Root directory of the drake project,
#' or if \code{search} is \code{TRUE}, either the
#' project root or a subdirectory of the project.
#' @param search If \code{TRUE}, search parent directories
#' to find the nearest drake cache. Otherwise, look in the
#' current working directory only.
#' @examples
#' \dontrun{
#' load_basic_example()
#' make(my_plan)
#' status() # Deprecated. Use progress() instead.
#' status(small, large)
#' status(list = c("small", "large"))
#' status(no_imported_objects = TRUE)
#' }
status = function(..., list = character(0), no_imported_objects = FALSE, 
                    imported_files_only = logical(0), path = getwd(), search = TRUE){
  .Deprecated("progress", package = "drake",
              msg = "status() is deprecated. Use progress() instead.")  
  progress(..., list = list, no_imported_objects = no_imported_objects,
    imported_files_only = imported_files_only, path = path, search = search)
}
