% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/conf_bands.R
\name{conf_bands}
\alias{conf_bands}
\title{Confidence interval for a scluminex object}
\usage{
conf_bands(x, analyte = NULL, xvalue, level = 0.95,
  interval = "confidence")
}
\arguments{
\item{x}{a \code{scluminex} object.}

\item{analyte}{character vector specifying the analytes to estimate the
interval. Default \code{NULL} (all analytes).}

\item{xvalue}{vector of numeric values of the concentration.}

\item{level}{numeric value for interval confidence or prediction level.
Default 0.95.}

\item{interval}{character defining type of interval, either 'confidence'
or 'prediction'. Default 'confidence'.}
}
\value{
A \code{data.frame} with predicted response, lower and upper
confidence (prediction) limits,
standard error, concentration value, analyte, interval method and
background method.
}
\description{
Computes confidence or prediction interval for the
response variable given a concentration value.
}
\details{
Two types of interval can be estimated
'prediction' interval and 'confidence' interval. If the did not
converge the function returns \code{NA} for all \code{xvalue}. If the function
cannot estimate the value \code{NaN} is returned.
}
\examples{
# Load data and fit models
data(ecdata)
data(mfidata)

plate1 <- mfidata[mfidata$plate=="plate_1",]
datasets <- data_selection(plate1, ecfile = ecdata)

background <- datasets[[1]]$background
standard <- datasets[[1]]$standard
mod <- scluminex(plateid = "plate_1", standard = standard,
background = background, bkg = "ignore",lfct="SSl4",
fmfi = "mfi", verbose = FALSE)

# Confidence-prediction intervals for FGF analyte
conf_bands(mod, "FGF", xvalue = c(1,3,4), interval = "confidence")
conf_bands(mod, "FGF", xvalue = c(1,3,4), interval = "prediction")

# For all analytes the prediction interval
conf_bands(mod, xvalue = 0.5, interval = "prediction")
}
\references{
Ruckstuhl, A. (2010). Introduction to Nonlinear Regression.
http://stat.ethz.ch/~stahel/courses/cheming/nlreg10E.pdf
}
\seealso{
\code{\link{predict.nls}}
}

