% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick.R
\name{pick}
\alias{pick}
\title{Select a subset of columns}
\usage{
pick(...)
}
\arguments{
\item{...}{<\code{\link[=dplyr_tidy_select]{tidy-select}}>

Columns to pick.

You can't pick grouping columns because they are already automatically
handled by the verb (i.e. \code{\link[=summarise]{summarise()}} or \code{\link[=mutate]{mutate()}}).}
}
\value{
A tibble containing the selected columns for the current group.
}
\description{
\code{pick()} provides a way to easily select a subset of columns from your data
using \code{\link[=select]{select()}} semantics while inside a
\link[=dplyr_data_masking]{"data-masking"} function like \code{\link[=mutate]{mutate()}} or
\code{\link[=summarise]{summarise()}}. \code{pick()} returns a data frame containing the selected columns
for the current group.

\code{pick()} is complementary to \code{\link[=across]{across()}}:
\itemize{
\item With \code{pick()}, you typically apply a function to the full data frame.
\item With \code{across()}, you typically apply a function to each column.
}
}
\details{
Theoretically, \code{pick()} is intended to be replaceable with an equivalent call
to \code{tibble()}. For example, \code{pick(a, c)} could be replaced with
\code{tibble(a = a, c = c)}, and \code{pick(everything())} on a data frame with cols
\code{a}, \code{b}, and \code{c} could be replaced with \code{tibble(a = a, b = b, c = c)}.
}
\examples{
df <- tibble(
  x = c(3, 2, 2, 2, 1),
  y = c(0, 2, 1, 1, 4),
  z1 = c("a", "a", "a", "b", "a"),
  z2 = c("c", "d", "d", "a", "c")
)
df

# `pick()` provides a way to select a subset of your columns using
# tidyselect. It returns a data frame.
df \%>\% mutate(cols = pick(x, y))

# This is useful for functions that take data frames as inputs.
# For example, you can compute a joint rank between `x` and `y`.
df \%>\% mutate(rank = dense_rank(pick(x, y)))

# `pick()` is also useful as a bridge between data-masking functions (like
# `mutate()` or `group_by()`) and functions with tidy-select behavior (like
# `select()`). For example, you can use `pick()` to create a wrapper around
# `group_by()` that takes a tidy-selection of columns to group on. For more
# bridge patterns, see
# https://rlang.r-lib.org/reference/topic-data-mask-programming.html#bridge-patterns.
my_group_by <- function(data, cols) {
  group_by(data, pick({{ cols }}))
}

df \%>\% my_group_by(c(x, starts_with("z")))

# Or you can use it to dynamically select columns to `count()` by
df \%>\% count(pick(starts_with("z")))
}
\seealso{
\code{\link[=across]{across()}}
}
