% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stow.R
\name{stow_info}
\alias{stow_info}
\alias{stow_path}
\alias{stow_exists}
\alias{stow_size}
\alias{stow_remove}
\title{get info about stowed files}
\usage{
stow_info(filename = NULL)

stow_path(filename = NULL)

stow_exists(filename = NULL)

stow_size(filename = NULL)

stow_remove(filename = NULL, .delete_stow_dir_confirm = FALSE)
}
\arguments{
\item{filename}{character filename of stowed file; if NULL, then information about
\emph{all} stowed files or the directory where files are stowed is returned}

\item{.delete_stow_dir_confirm}{set to TRUE in order to delete the entire stow directory without interactive
user confirmation}
}
\value{
for \code{stow_info()}, a tibble of file or folder information;
for \code{stow_path()}, a character path to the stowed file or stow directory;
for \code{stow_exists()}, a logical;
for \code{stow_size()}, a fs::
}
\description{
get info about stowed files

get the path to a stowed file (or the stow directory)

test if a stowed file (or the stow directory) exists

get the size of a stowed file

remove a stowed file (or the stow entire directory)
}
\examples{
Sys.setenv(R_USER_DATA_DIR = tempfile("stow"))

stow_path()

stow("https://github.com/geomarker-io/appc/releases/download/v0.1.0/nei_2020.rds")

stow_path("nei_2020.rds")

stow_exists("nei_2020.rds")

stow_size("nei_2020.rds")

stow("https://github.com/geomarker-io/appc/releases/download/v0.1.0/nei_2017.rds")

stow_info("nei_2017.rds")

stow_info()

stow_size()

stow_remove(.delete_stow_dir_confirm = TRUE)
}
