% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting.R
\name{treesToPDF}
\alias{treesToPDF}
\title{Simple function for plotting a lot of trees into a pdf}
\usage{
treesToPDF(plots, file, nrow = 2, ncol = 2, ...)
}
\arguments{
\item{plots}{list of tree plots (from plotTrees)}

\item{file}{output file name}

\item{nrow}{number of rows per page}

\item{ncol}{size of tip shape objects}

\item{...}{optional arguments passed to grDevices::pdf}
}
\value{
a PDF of tree plots
}
\description{
\code{treesToPDF} exports trees to a pdf in an orderly fashion
}
\examples{
\dontrun{
data(ExampleClones)
trees <- getTrees(ExampleClones[10,])
plots <- plotTrees(trees)
treesToPDF(plots,"test.pdf",width=5,height=6)
}
}
\seealso{
\link{plotTrees}
}
