% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeFunctions.R
\name{bootstrapTrees}
\alias{bootstrapTrees}
\title{Create a bootstrap distribution for clone sequence alignments, and estimate 
trees for each bootstrap replicate.}
\usage{
bootstrapTrees(
  clones,
  bootstraps,
  nproc = 1,
  trait = NULL,
  dir = NULL,
  id = NULL,
  modelfile = NULL,
  build = "pratchet",
  exec = NULL,
  igphyml = NULL,
  fixtrees = FALSE,
  quiet = 0,
  rm_temp = TRUE,
  palette = NULL,
  resolve = 2,
  rep = NULL,
  keeptrees = TRUE,
  lfile = NULL,
  seq = "sequence",
  downsample = FALSE,
  tip_switch = 20,
  ...
)
}
\arguments{
\item{clones}{tibble \code{airrClone} objects, the output of 
\link{formatClones}}

\item{bootstraps}{number of bootstrap replicates to perform}

\item{nproc}{number of cores to parallelize computations}

\item{trait}{trait to use for parsimony models (required if 
\code{igphyml} specified)}

\item{dir}{directory where temporary files will be placed (required
if \code{igphyml} or \code{dnapars} specified)}

\item{id}{unique identifer for this analysis (required if 
\code{igphyml} or \code{dnapars} specified)}

\item{modelfile}{file specifying parsimony model to use}

\item{build}{program to use for tree building (phangorn, dnapars)}

\item{exec}{location of desired phylogenetic executable}

\item{igphyml}{location of igphyml executible if trait models desired}

\item{fixtrees}{keep tree topologies fixed?
(bootstrapping will not be perfomed)}

\item{quiet}{amount of rubbish to print to console}

\item{rm_temp}{remove temporary files (default=TRUE)}

\item{palette}{a named vector specifying colors for each state}

\item{resolve}{how should polytomies be resolved?}

\item{rep}{current bootstrap replicate (experimental)}

\item{keeptrees}{keep trees estimated from bootstrap replicates? (TRUE)}

\item{lfile}{lineage file input to igphyml if desired (experimental)}

\item{seq}{column name containing sequence information}

\item{downsample}{downsample clones to have a maximum specified tip/switch ratio?}

\item{tip_switch}{maximum allowed tip/switch ratio if downsample=TRUE}

\item{...}{additional arguments to be passed to tree building program}
}
\value{
A list of trees and/or switch counts for each bootstrap replicate.
}
\description{
\code{bootstrapTrees} Phylogenetic bootstrap function.
}
\details{
Tree building details are the same as \link{getTrees}. 
If \code{keeptrees=TRUE} (default) the returned object will contain a list 
named "trees" which contains a list of estimated tree objects for each 
bootstrap replicate. The object is structured like: 
trees[[<replicate>]][[<tree index>]]. If \code{igphyml} is specified 
(as well as \code{trait}), the returned object 
will contain a \code{tibble} named "switches" containing switch count 
information. This object can be passed to \link{testSP} and other functions 
to perform parsimony based trait value tests.
}
\examples{
\dontrun{
data(ExampleAirr)
ExampleAirr$sample_id <- sample(ExampleAirr$sample_id)
clones <- formatClones(ExampleAirr, trait="sample_id")

igphyml <- "~/apps/igphyml/src/igphyml"
btrees <- bootstrapTrees(clones[1:2], bootstraps=10, nproc=1,
   igphyml=igphyml, trait="sample_id")
plotTrees(btrees$trees[[4]])[[1]]
testPS(btrees$switches)
}
}
\seealso{
Uses output from \link{formatClones} with similar arguments to 
\link{getTrees}. Output can be visualized with \link{plotTrees}, and tested
with \link{testPS}, \link{testSC}, and \link{testSP}.
}
