% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parseClassFun}
\alias{parseClassFun}
\title{Make the LaTeX/HTML table. Generic function}
\usage{
parseClassFun(
  table,
  col.order = NULL,
  levels_to_keep = NULL,
  group_rows_labels = NULL
)
}
\arguments{
\item{table}{The output of \code{\link[=descTab]{descTab()}} or \code{\link[=anaBiv]{anaBiv()}}, an S4 object.}

\item{col.order}{Optional. A vector containing the column order. If set, must contains at least all levels of group. Three columns created are "var", "Total", and "pvalue" which can be present in the vector}

\item{levels_to_keep}{Optional, named list. If the variable is binary, which level to keep. Default is the last level of levels(variable). Must be as: list("variable name" = "level to keep").}

\item{group_rows_labels}{Optional, named list. Create row labels in order to regroup them. Must be as list("label" = c("var1", "var2), "label2" = c("var3", "var4")).}
}
\value{
An HTML/LaTex file which can be used directly in Rmarkdown and copy paste
}
\description{
Make the LaTeX/HTML table. Generic function
}
\examples{
data(iris)
library(stringi)
iris$fact_1<-as.factor(as.character(sample(1:5, 150, replace = TRUE)))
n_na<-sample(1:150, 30)
iris[n_na, "fact_1"]<-NA
iris$fact_2<-as.factor(as.character(stri_rand_strings(150, 1, '[A-B]')))
iris$num<-runif(150, min = 0, max = 100)
n_na<-sample(1:150, 5)
iris[n_na, "num"]<-NA
iris_test<-descTab(iris, group = "Species", na.print = TRUE)
testParse<-parseClassFun(iris_test, levels_to_keep = list("fact_2" =  "A"),
group_rows_labels = list("Size" = c("Petal.Length", "Petal.Width"),
"My_f" = c("num", "fact_2")))
}
