% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso.R
\name{dodgr_isodists}
\alias{dodgr_isodists}
\title{dodgr_isodists}
\usage{
dodgr_isodists(graph, from = NULL, dlim = NULL, heap = "BHeap")
}
\arguments{
\item{graph}{\code{data.frame} or equivalent object representing the network
graph (see Notes)}

\item{from}{Vector or matrix of points \strong{from} which isodistances are to
be calculated.}

\item{dlim}{Vector of desired limits of isodistances in metres.}

\item{heap}{Type of heap to use in priority queue. Options include
Fibonacci Heap (default; \code{FHeap}), Binary Heap (\code{BHeap}),
\code{Radix}, Trinomial Heap (\code{TriHeap}), Extended Trinomial Heap
(\code{TriHeapExt}, and 2-3 Heap (\code{Heap23}).}
}
\value{
A single \code{data.frame} of isodistances as points sorted anticlockwise
around each origin (\code{from}) point, with columns denoting the \code{from} points
and \code{dlim} value(s). The isodistance contours are given as \code{id} values and
associated coordinates of the series of points from each \code{from} point at the
specified isodistances.
}
\description{
Calculate isodistance contours from specified points. Function is fully
vectorized to calculate accept vectors of central points and vectors
defining multiple isodistances.
}
\examples{
graph <- weight_streetnet (hampi)
from <- sample (graph$from_id, size = 100)
dlim <- c (1, 2, 5, 10, 20) * 100
d <- dodgr_isodists (graph, from = from, dlim)
}
