# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' get_to_from
#'
#' Get one pair of two and from edges and vertices. Main task is to make sure
#' that bi-directed edges ("intermediate_double") correctly return the
#' **different** values of from and to vertices and edges.
#'
#' @noRd
NULL

#' rcpp_contract_graph
#'
#' Removes nodes and edges from a graph that are not needed for routing
#'
#' @param graph graph to be processed
#'
#' @return \code{Rcpp::List} containing one \code{data.frame} with the
#' contracted graph, one \code{data.frame} with the original graph and one
#' \code{data.frame} containing information about the relating edge ids of the
#' original and contracted graph.
#'
#' @noRd
rcpp_contract_graph <- function(graph, vertlist_in) {
    .Call(`_dodgr_rcpp_contract_graph`, graph, vertlist_in)
}

#' graph_has_components
#'
#' Does a graph have a vector of connected component IDs? Only used in
#' \code{sample_one_vertex}
#' @noRd
NULL

#' graph_from_df
#'
#' Convert a standard graph data.frame into an object of class graph. Graphs
#' are standardised with the function \code{dodgr_convert_graph()$graph}, and contain
#' only the four columns [from, to, d, w]
#' @noRd
NULL

#' identify_graph_components
#'
#' Identify initial graph components for each **vertex**
#' Identification for edges is subsequently perrformed with 
#' \code{rcpp_get_component_vector}.
#'
#' @param v unordered_map <vertex_id_t, vertex_t>
#' @param com component map from each vertex to component numbers
#' @noRd
NULL

#' rcpp_get_component_vector
#'
#' Get component numbers for each edge of graph
#'
#' @param graph graph to be processed
#'
#' @return Two vectors: one of edge IDs and one of corresponding component
#' numbers
#' @noRd
rcpp_get_component_vector <- function(graph) {
    .Call(`_dodgr_rcpp_get_component_vector`, graph)
}

#' sample_one_edge_no_comps
#'
#' Sample one edge for graph that has no pre-calculated components. Only used
#' in \code{sample_one_vertex}
#'
#' @param edge_map edge_map
#' @return std::vector of 2 elements: [0] with value of largest connected 
#' component; [1] with random index to one edge that is part of that component.
#' @noRd
NULL

#' sample_one_edge_with_comps
#'
#' Sample one edge for graph that has pre-calculated components. Only used in
#' \code{sample_one_vertex}
#'
#' @param edge_map edge_map
#' @return Random index to one edge that is part of the largest connected
#' component.
#' @noRd
NULL

#' rcpp_sample_graph
#'
#' Randomly sample one connected componnent of a graph
#'
#' @param graph graph to be processed
#' @param nverts_to_sample Number of vertices to sample
#' @param quiet If TRUE, display progress
#'
#' @return Smaller sub-set of \code{graph}
#'
#' @noRd
rcpp_sample_graph <- function(graph, nverts_to_sample) {
    .Call(`_dodgr_rcpp_sample_graph`, graph, nverts_to_sample)
}

#' rcpp_get_sp
#'
#' @noRd
rcpp_get_sp <- function(graph, vert_map_in, fromi, toi, heap_type) {
    .Call(`_dodgr_rcpp_get_sp`, graph, vert_map_in, fromi, toi, heap_type)
}

#' rcpp_sf_as_network
#'
#' Return OSM data in Simple Features format
#'
#' @param sf_lines An sf collection of LINESTRING objects
#' @param pr Rcpp::DataFrame containing the weighting profile
#'
#' @return Rcpp::List objects of OSM data
#'
#' @noRd
rcpp_sf_as_network <- function(sf_lines, pr) {
    .Call(`_dodgr_rcpp_sf_as_network`, sf_lines, pr)
}

#' rcpp_points_index
#'
#' Get index of nearest vertices to list of points
#'
#' @param graph Rcpp::DataFrame containing the graph
#' @param pts Rcpp::DataFrame containing the routing points
#'
#' @return Rcpp::NumericVector index into graph of nearest points
#'
#' @noRd
rcpp_points_index <- function(xy, pts) {
    .Call(`_dodgr_rcpp_points_index`, xy, pts)
}

