% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_colnames.r
\name{assign_colnames}
\alias{assign_colnames}
\title{Make a specific row the column names for the specified data.frame}
\usage{
assign_colnames(dat, row, remove = TRUE, remove_previous = remove)
}
\arguments{
\item{dat}{can be any \code{data.frame} but is intended for use with
ones retuned by this package}

\item{row}{numeric value indicating the row number that is to become
the column names}

\item{remove}{remove row specified by \code{row} after making it
the column names? (Default: \code{TRUE})}

\item{remove_previous}{remove any rows preceding \code{row}? (Default:
\code{TRUE} but will be assigned whatever is given for
\code{remove}).}
}
\value{
\code{data.frame}
}
\description{
Many tables in Word documents are in twisted formats where there may be
labels or other oddities mixed in that make it difficult to work with the
underlying data. This function makes it easy to identify a particular row
in a scraped \code{data.frame} as the one containing column names and
have it become the column names, removing it and (optionally) all of the
rows before it (since that's usually what needs to be done).
}
\examples{
# a "real" Word doc
real_world <- read_docx(system.file("examples/realworld.docx", package="docxtractr"))
docx_tbl_count(real_world)

# get all the tables
tbls <- docx_extract_all_tbls(real_world)

# make table 1 better
assign_colnames(tbls[[1]], 2)

# make table 5 better
assign_colnames(tbls[[5]], 2)
}
\seealso{
\code{\link{docx_extract_all}}, \code{\link{docx_extract_tbl}}
}
