% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nint.R
\name{nint_validateSpace}
\alias{nint_validateSpace}
\title{Validate Space}
\usage{
nint_validateSpace(x)
}
\arguments{
\item{x}{a space or list structure of spaces.}
}
\value{
\code{nint_validateSpace} returns 0 if everything is fine, or an error code.
See \code{\link{nint_ERROR}}.
}
\description{
\code{nint_validateSpace} performs a couple of checks on a space or list structure of spaces to ensure it is properly defined.
}
\examples{
## valid
s = nint_space()
s
nint_validateSpace(s)

s = nint_space(nint_intvDim(-1, 1))
s
nint_validateSpace(s)

## -1001
s = nint_space(1)
s
nint_validateSpace(s)

## -1002
s = nint_space(list(nint_scatDim(c(1, 2)), nint_scatDim(c(1, 2, 3))))
s
nint_validateSpace(s)

s = nint_space(nint_scatDim(c(1, 2)),
               nint_scatDim(c(1, 2, 3)))
s
nint_validateSpace(s)

## -1003
nint_validateSpace(1)
nint_validateSpace(list(nint_space())) # valid
nint_validateSpace(list(1))

## -1004
s1 = nint_space(nint_gridDim(1:3),
                nint_scatDim(c(0, 1)))
s2 = nint_space(s1[[1]])
s1 # 2D
s2 # 1D
nint_validateSpace(list(s1, s2))
}
\seealso{
\code{\link{nint_ERROR}}, \code{\link{nint_space}}
}

