% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmbc_init.R
\name{dmbc_init}
\alias{dmbc_init}
\title{Function to compute the starting values before fitting a DMBC models.}
\usage{
dmbc_init(D, p, G, family, random.start, method, partition)
}
\arguments{
\item{D}{A list whose elements are the dissimilarity matrices corresponding
to the judgments expressed by the \emph{S} subjects/raters. These matrices
must be defined as a \code{dist} object.}

\item{p}{A length-one numeric vector indicating the number of dimensions of the
latent space.}

\item{G}{A length-one numeric vector indicating the number of cluster to
partition the \emph{S} subjects.}

\item{family}{A length-one character vector representing the type of data to
analyze. Currently, it accepts only the 'binomial' value, but future
developments will include the possibility to analyze continuous,
multinomial and count data.}

\item{random.start}{A length-one logical vector. If \code{TRUE} the starting
values are drawn randomly, otherwise.}

\item{method}{A length-one character vector specifying the distance
measure to use in determining the initial partition. Allowed values are
those from the \code{\link{dist}()} function.}

\item{partition}{A length-one numeric vector providing the user-defined
starting partition.}
}
\value{
A named \code{list} with the following items:
  \describe{
    \item{\code{z}: }{array of latent coordinates starting values}
    \item{\code{x}: }{numeric vector of initial cluster memberships}
    \item{\code{ng}: }{numeric vector of initial cluster sizes}
    \item{\code{alpha}: }{numeric vector of alpha starting values}
    \item{\code{eta}: }{numeric vector of eta starting values}
    \item{\code{sigma2}: }{numeric vector of sigma2 starting values}
    \item{\code{lambda}: }{numeric vector of lambda starting values}
  }
}
\description{
\code{dmbc_init()} is the main function that estimates a DMBC model.
}
\examples{
data(simdiss, package = "dmbc")
dmbc_init(simdiss@diss, p = 2, G = 3, family = "binomial", random.start = TRUE)
}
\references{
Venturini, S., Piccarreta, R. (2021), "A Bayesian Approach for Model-Based
  Clustering of Several Binary Dissimilarity Matrices: the \pkg{dmbc}
  Package in \code{R}", Journal of Statistical Software, 100, 16, 1--35, <10.18637/jss.v100.i16>.
}
\seealso{
\code{\link{dmbc}()} for fitting a DMBC model.
}
\author{
Sergio Venturini \email{sergio.venturini@unicatt.it}
}
