% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasEquiv_EffectSize_Base.R
\name{delta_mean_item}
\alias{delta_mean_item}
\title{Expected bias to item mean}
\usage{
delta_mean_item(LambdaR, ThreshR, LambdaF, ThreshF, MeanF, VarF,
  categorical = FALSE, stepsize = 0.001)
}
\arguments{
\item{LambdaR}{is the factor loading of the item onto the factor of
interest for the reference group.}

\item{ThreshR}{is the indicator intercept (for continuous
indicators) or a vector of thresholds (for
categorical indicators) for the reference group.}

\item{LambdaF}{is the factor loading of the item onto the factor of
interest for the focal group.}

\item{ThreshF}{is the indicator intercept (for continuous
indicators) or a vector of thresholds (for
categorical indicators) for the focal group.}

\item{MeanF}{is the factor mean in the focal group}

\item{VarF}{is the factor variances in the focal group.}

\item{categorical}{is a Boolean variable declaring whether the variables
in the model are ordered categorical. Models in which some variables are
categorical and others are continuous are not supported. If no value is
provided, categorical defaults to \code{FALSE}, although if a vector of
thresholds are provided, categorical will be forced to
\code{TRUE}. A graded response model with probit link (e.g., DWLS in
lavaan or WLSMV in Mplus) is used for categorical variables. If you desire
for other categorical models (e.g., IRT parameterization) to be supported,
e-mail the maintainer.}

\item{stepsize}{is the interval width for the Riemann sum used to estimate
the integral in equation 6 of Nye & Drasgow (2011). Default value is .001.
A larger value can be used for faster performance; accuracy is
excellent at \code{stepsize = .01} in my simulations.}
}
\value{
The expected bias in item mean due to
measurement nonequivalence in equation 4 of Nye & Drasgow (2011).
}
\description{
\code{delta_mean_item} computes the expected bias in item mean due to
measurement nonequivalence.
}
\details{
\code{delta_mean_item} is called by \code{dmacs_summary_single}, which
in turn is called by \code{\link{lavaan_dmacs}} and
\code{\link{mplus_dmacs}}, which are the only functions in this
package intended for casual users
}
\section{References}{

Nye, C. & Drasgow, F. (2011). Effect size indices for analyses of
measurement equivalence: Understanding the practical importance of
differences between groups. \emph{Journal of Applied Psychology, 96}(5),
966-980.
}

\examples{
LambdaF <- 0.74
LambdaR <- 0.76
ThreshF <- 1.28
ThreshR <- 0.65
MeanF   <- 0.21
VarF    <- 1.76
delta_mean_item(LambdaR, ThreshR, LambdaF, ThreshF, MeanF, VarF)

}
