% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm-from-src.R
\name{dm_from_src}
\alias{dm_from_src}
\title{Load a dm from a remote data source}
\usage{
dm_from_src(src = NULL, table_names = NULL, learn_keys = NULL, ...)
}
\arguments{
\item{src}{A \pkg{dplyr} table source object or a
\code{\link[DBI:DBIConnection-class]{DBI::DBIConnection}} object is accepted.}

\item{table_names}{A character vector of the names of the tables to include.}

\item{learn_keys}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Set to \code{TRUE} to query the definition of primary and
foreign keys from the database.
Currently works only for Postgres and SQL Server databases.
The default attempts to query and issues an informative message.}

\item{...}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Additional parameters for the schema learning query.
\itemize{
\item \code{schema}: supported for MSSQL (default: \code{"dbo"}), Postgres (default: \code{"public"}), and MariaDB/MySQL
(default: current database). Learn the tables in a specific schema (or database for MariaDB/MySQL).
\item \code{dbname}: supported for MSSQL. Access different databases on the connected MSSQL-server;
default: active database.
\item \code{table_type}: supported for Postgres (default: \code{"BASE TABLE"}). Specify the table type. Options are:
\enumerate{
\item \code{"BASE TABLE"} for a persistent table (normal table type)
\item \code{"VIEW"} for a view
\item \code{"FOREIGN TABLE"} for a foreign table
\item \code{"LOCAL TEMPORARY"} for a temporary table
}
}}
}
\value{
A \code{dm} object.
}
\description{
\code{dm_from_src()} creates a \link{dm} from some or all tables in a \link{src}
(a database or an environment) or which are accessible via a DBI-Connection.
For Postgres and SQL Server databases, primary and foreign keys
are imported from the database.
}
\examples{
\dontshow{if (dm:::dm_has_financial()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
con <- DBI::dbConnect(
  RMariaDB::MariaDB(),
  username = "guest",
  password = "relational",
  dbname = "Financial_ijs",
  host = "relational.fit.cvut.cz"
)

dm_from_src(con)

DBI::dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
