% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select-tbl.R
\name{dm_select_tbl}
\alias{dm_select_tbl}
\alias{dm_rename_tbl}
\title{Select and rename tables}
\usage{
dm_select_tbl(dm, ...)

dm_rename_tbl(dm, ...)
}
\arguments{
\item{dm}{A \code{\link{dm}} object.}

\item{...}{One or more table names of the tables of the \code{\link{dm}} object.
\code{tidyselect} is supported, see \code{\link[dplyr:select]{dplyr::select()}} for details on the semantics.}
}
\value{
The input \code{dm} with tables renamed or removed.
}
\description{
\code{dm_select_tbl()} keeps the selected tables and their relationships,
optionally renaming them.

\code{dm_rename_tbl()} renames tables.
}
\examples{
dm_nycflights13() \%>\%
  dm_select_tbl(airports, fl = flights)
dm_nycflights13() \%>\%
  dm_rename_tbl(ap = airports, fl = flights)
}
\seealso{
\code{\link[=dm_rm_tbl]{dm_rm_tbl()}}
}
