% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_tbl_dbi.R
\name{eda_paged_report.tbl_dbi}
\alias{eda_paged_report.tbl_dbi}
\title{Reporting the information of EDA for table of the DBMS}
\usage{
\method{eda_paged_report}{tbl_dbi}(
  .data,
  target = NULL,
  output_format = c("pdf", "html")[1],
  output_file = NULL,
  output_dir = tempdir(),
  browse = TRUE,
  title = "EDA Report",
  subtitle = deparse(substitute(.data)),
  author = "dlookr",
  abstract_title = "Report Overview",
  abstract = NULL,
  title_color = "black",
  subtitle_color = "blue",
  cover_img = NULL,
  create_date = Sys.time(),
  logo_img = NULL,
  theme = c("orange", "blue")[1],
  sample_percent = 100,
  in_database = FALSE,
  collect_size = Inf,
  as_factor = TRUE,
  ...
)
}
\arguments{
\item{.data}{a tbl_dbi.}

\item{target}{character. target variable.}

\item{output_format}{report output type. Choose either "pdf" and "html".
"pdf" create pdf file by rmarkdown::render() and pagedown::chrome_print(). so, 
you needed Chrome web browser on computer.  
"html" create html file by rmarkdown::render().}

\item{output_file}{name of generated file. default is NULL.}

\item{output_dir}{name of directory to generate report file. default is tempdir().}

\item{browse}{logical. choose whether to output the report results to the browser.}

\item{title}{character. title of report. default is "Data Diagnosis Report".}

\item{subtitle}{character. subtitle of report. default is name of data.}

\item{author}{character. author of report. default is "dlookr".}

\item{abstract_title}{character. abstract title of report. default is 
"Report Overview".}

\item{abstract}{character. abstract of report.}

\item{title_color}{character. color of title. default is "black".}

\item{subtitle_color}{character. color of title. default is "blue".}

\item{cover_img}{character. name of cover image.}

\item{create_date}{Date or POSIXct, character. The date on which the report is generated. 
The default value is the result of Sys.time().}

\item{logo_img}{character. name of logo image on top right.}

\item{theme}{character. name of theme for report. support "orange" and "blue". 
default is "orange".}

\item{sample_percent}{numeric. Sample percent of data for performing EDA. 
It has a value between (0, 100]. 100 means all data, and 5 means 5\% of sample data.
This is useful for data with a large number of observations.}

\item{in_database}{Specifies whether to perform in-database operations. 
If TRUE, most operations are performed in the DBMS. if FALSE, 
table data is taken in R and operated in-memory. Not yet supported in_database = TRUE.}

\item{collect_size}{a integer. The number of data samples from the DBMS to R. 
Applies only if in_database = FALSE.}

\item{as_factor}{logical. whether to convert to factor when importing a character type variable from DBMS table into R.}

\item{...}{arguments to be passed to methods.}
}
\description{
The eda_paged_report() paged report the information for EDA of the DBMS table through tbl_dbi
}
\details{
Generate generalized EDA report automatically. 
You can choose to output to pdf and html files.
This feature is useful for EDA of data with many variables, 
rather than data with fewer variables.

Create an  PDF through the Chrome DevTools Protocol. If you want to create PDF, 
Google Chrome or Microsoft Edge (or Chromium on Linux) must be installed prior to using this function.
If not installed, you must use output_format = "html".
}
\section{Reported information}{

The EDA process will report the following information:

\itemize{
  \item Overview
  \itemize{
    \item Data Structures 
    \item Job Informations
  } 
  \item Univariate Analysis
  \itemize{
    \item Descriptive Statistics
    \itemize{
      \item Numerical Variables
      \item Categorical Variables
    }
    \item Normality Test
  } 
  \item Bivariate Analysis
  \itemize{
    \item Compare Numerical Variables
    \item Compare Categorical Variables
  } 
  \item Multivariate Analysis
  \itemize{
    \item Correlation Analysis
    \itemize{
      \item Correlation Coefficient Matrix
      \item Correlation Plot
    }
  }
  \item Target based Analysis
  \itemize{
    \item Grouped Numerical Variables
    \item Grouped Categorical Variables
    \item Grouped Correlation
  }
}
}

\examples{
\donttest{
if (FALSE) {
library(dplyr)

# Generate data for the example
heartfailure2 <- heartfailure
heartfailure2[sample(seq(NROW(heartfailure2)), 20), "platelets"] <- NA
heartfailure2[sample(seq(NROW(heartfailure2)), 5), "smoking"] <- NA

# connect DBMS
con_sqlite <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

# copy heartfailure2 to the DBMS with a table named TB_HEARTFAILURE
copy_to(con_sqlite, heartfailure2, name = "TB_HEARTFAILURE", overwrite = TRUE)

# reporting the diagnosis information -------------------------
# create pdf file. file name is EDA_Paged_Report.pdf
con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  eda_paged_report(target = "death_event")
  
# create pdf file. file name is EDA.pdf, and collect size is 250
con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  eda_paged_report(collect_size = 250, output_file = "EDA.pdf")
  
# Disconnect DBMS   
DBI::dbDisconnect(con_sqlite)
}
}

}
\seealso{
\code{\link{eda_paged_report.data.frame}}.
}
