% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_by.R
\name{print.relate}
\alias{print.relate}
\title{Summarizing relate information}
\usage{
\method{print}{relate}(x, ...)
}
\arguments{
\item{x}{an object of class "relate", usually, a result of a call to relate().}

\item{...}{further arguments passed to or from other methods.}
}
\description{
print and summary method for "relate" class.
}
\details{
print.relate() tries to be smart about formatting four kinds of relate.
summary.relate() tries to be smart about formatting four kinds of relate.
}
\examples{
\dontrun{
# If the target variable is a categorical variable
categ <- target_by(heartfailure, death_event)

# If the variable of interest is a categorical variable
cat_cat <- relate(categ, hblood_pressure)

# Print bins class object
cat_cat

summary(cat_cat)
}

# If the target variable is a categorical variable
categ <- target_by(heartfailure, death_event)

# If the variable of interest is a numerical variable
cat_num <- relate(categ, sodium)
cat_num
summary(cat_num)

# plot(cat_num)

# If the variable of interest is a categorical variable
cat_cat <- relate(categ, hblood_pressure)
cat_cat
summary(cat_cat)
 
# plot(cat_cat)

##---------------------------------------------------
# If the target variable is a numerical variable
num <- target_by(heartfailure, creatinine)

# If the variable of interest is a numerical variable
num_num <- relate(num, sodium)
num_num
summary(num_num)

# plot(num_num)

# If the variable of interest is a categorical variable
num_cat <- relate(num, smoking)
num_cat
summary(num_cat)

# plot(num_cat)

# Not allow typographic
# plot(num_cat, typographic = FALSE)

}
\seealso{
\code{\link{plot.relate}}.
}
