% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{summary.performance_bin}
\alias{summary.performance_bin}
\title{Summarizing Performance for Binned Variable}
\usage{
\method{summary}{performance_bin}(object, ...)
}
\arguments{
\item{object}{an object of class "performance_bin", usually, a result of a call to performance_bin().}

\item{...}{further arguments to be passed from or to other methods.}
}
\value{
NULL.
}
\description{
summary method for "performance_bin". summary metrics to evaluate the performance 
of binomial classification model.
}
\details{
print() to print only binning table information of "performance_bin" objects.
summary.performance_bin() includes general metrics and result of significance tests life follows.:
\itemize{
  \item Binning Table : Metrics by bins.
  \itemize{
    \item CntRec, CntPos, CntNeg, RatePos, RateNeg, Odds, WoE, IV, JSD, AUC.
  }
  \item General Metrics.
  \itemize{
    \item Gini index.
    \item Jeffrey's Information Value.
    \item Jensen-Shannon Divergence.
    \item Kolmogorov-Smirnov Statistics.
    \item Herfindahl-Hirschman Index.
    \item normalized Herfindahl-Hirschman Index.
    \item Cramer's V Statistics.
  } 
  \item Table of Significance Tests.
}
}
\examples{
# Generate data for the example
heartfailure2 <- heartfailure

set.seed(123)
heartfailure2[sample(seq(NROW(heartfailure2)), 5), "creatinine"] <- NA

# Change the target variable to 0(negative) and 1(positive).
heartfailure2$death_event_2 <- ifelse(heartfailure2$death_event \%in\% "Yes", 1, 0)

# Binnig from creatinine to platelets_bin.
breaks <- c(0,  1,  2, 10)
heartfailure2$creatinine_bin <- cut(heartfailure2$creatinine, breaks)

# Diagnose performance binned variable
perf <- performance_bin(heartfailure2$death_event_2, heartfailure2$creatinine_bin) 
perf
summary(perf)

# plot(perf)

# Diagnose performance binned variable without NA
perf <- performance_bin(heartfailure2$death_event_2, heartfailure2$creatinine_bin, na.rm = TRUE) 
perf
summary(perf)

# plot(perf)

}
\seealso{
\code{\link{performance_bin}}, \code{\link{plot.performance_bin}}, \code{\link{binning_by}}, 
\code{\link{summary.optimal_bins}}.
}
