% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputation.R
\name{summary.imputation}
\alias{summary.imputation}
\title{Summarizing imputation information}
\usage{
\method{summary}{imputation}(object, ...)
}
\arguments{
\item{object}{an object of class "imputation", usually, a result of a call to imputate_na() or
imputate_outlier().}

\item{...}{further arguments passed to or from other methods.}
}
\description{
print and summary method for "imputation" class.
}
\details{
summary.imputation tries to be smart about formatting two kinds of imputation.
}
\examples{
\donttest{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Impute missing values -----------------------------
# If the variable of interest is a numerical variable
income <- imputate_na(carseats, Income, US, method = "rpart")
income
summary(income)
plot(income)

# If the variable of interest is a categorical variable
urban <- imputate_na(carseats, Urban, US, method = "mice")
urban
summary(urban)
plot(urban)

# Impute outliers ----------------------------------
# If the variable of interest is a numerical variable
price <- imputate_outlier(carseats, Price, method = "capping")
price
summary(price)
plot(price)
}
}
\seealso{
\code{\link{imputate_na}}, \code{\link{imputate_outlier}}, \code{\link{summary.imputation}}.
}
