% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normality.R
\name{plot_normality}
\alias{plot_normality}
\alias{plot_normality.data.frame}
\title{Plot distribution information of numerical data}
\usage{
plot_normality(.data, ...)

\method{plot_normality}{data.frame}(.data, ...)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, plot_normality() will automatically
start with all variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.

See vignette("EDA") for an introduction to these concepts.}
}
\description{
The plot_normality() visualize distribution information
for normality test of the numerical data.
}
\details{
The scope of the visualization is the provide a distribution information.
Since the plot is drawn for each variable, if you specify more than
one variable in the ... argument, the specified number of plots are drawn.
}
\section{Distribution information}{

The plot derived from the numerical data visualization is as follows.

\itemize{
\item histogram by original data
\item q-q plot by original data
\item histogram by log transfer data
\item histogram by square root transfer data
}
}

\examples{
\donttest{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Visualization of all numerical variables
plot_normality(carseats)

# Select the variable to plot
plot_normality(carseats, Income, Price)
plot_normality(carseats, -Income, -Price)
plot_normality(carseats, 1)

# Using dplyr::grouped_df
library(dplyr)

gdata <- group_by(carseats, ShelveLoc, US)
plot_normality(carseats)
plot_normality(carseats, "Sales")

# Using pipes ---------------------------------
# Visualization of all numerical variables
carseats \%>\%
 plot_normality()

# Positive values select variables
carseats \%>\%
plot_normality(Income, Price)

# Positions values select variables
carseats \%>\%
 plot_normality(1)

# Using pipes & dplyr -------------------------
# Plot 'Sales' variable by 'ShelveLoc' and 'US'
carseats \%>\%
 group_by(ShelveLoc, US) \%>\%
 plot_normality(Sales)

# extract only those with 'ShelveLoc' variable level is "Good",
# and plot 'Income' by 'US'
carseats \%>\%
 filter(ShelveLoc == "Good") \%>\%
 group_by(US) \%>\%
 plot_normality(Income)
}
}
\seealso{
\code{\link{plot_normality.tbl_dbi}}, \code{\link{plot_outlier.data.frame}}.
}
