% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputation.R
\name{plot.imputation}
\alias{plot.imputation}
\title{Visualize Information for an "imputation" Object}
\usage{
\method{plot}{imputation}(x, ...)
}
\arguments{
\item{x}{an object of class "imputation", usually, a result of a call to imputate_na()
or imputate_outlier().}

\item{...}{arguments to be passed to methods, such as graphical parameters (see par).
only applies when the model argument is TRUE, and is used for ... of the plot.lm () function.}
}
\description{
Visualize two kinds of plot by attribute of `imputation` class.
The imputation of a numerical variable is a density plot,
and the imputation of a categorical variable is a bar plot.
}
\examples{
\donttest{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Imputate missing values -----------------------------
# If the variable of interest is a numarical variable
income <- imputate_na(carseats, Income, US, method = "rpart")
income
summary(income)
plot(income)

# If the variable of interest is a categorical variable
urban <- imputate_na(carseats, Urban, US, method = "mice")
urban
summary(urban)
plot(urban)

# Imputate outliers ----------------------------------
# If the variable of interest is a numarical variable
price <- imputate_outlier(carseats, Price, method = "capping")
price
summary(price)
plot(price)
}
}
\seealso{
\code{\link{imputate_na}}, \code{\link{imputate_outlier}}, \code{\link{summary.imputation}}.
}
