#' list_nodes
#'
#' Returns list of nodes
#'
#' @param url character: The DKAN site URL
#' @param credentials Optional list parameter. Default values are Cookie and Token generated by dkan_setup()
#' @param fields character vector: fields to be returned by the request
#' @param filters named character vector: filters to be applied to the search
#' @param pagesize numeric: Number of records to get per page (max = 20).
#' @param page numeric: The zero-based index of the page to get, defaults to 0.
#' @param as character: Output format. Options are: 'json', 'list', or 'df' (data frame)
#' @param ... Other optional parameters to be passed to the underlying GET request
#'
#' @return json, dkan_node (list), or data frame
#' @export
#'
#' @examples
#' \dontrun{
#' list_nodes(url = "http://demo.getdkan.com")
#' list_nodes(url = "http://demo.getdkan.com",
#'                fields = c('nid', 'type', 'uri'),
#'                filters = c(type='resource'))
#'                }
list_nodes <- function(url = get_url(),
                       credentials = list(cookie = dkanr::get_cookie(),
                                          token = dkanr::get_token()),
                       fields = NULL,
                       filters = NULL,
                       pagesize = NULL,
                       page = NULL,
                       as = "json", ...) {
  # Build query
  query <- NULL
  if (any(
    !is.null(fields),
    !is.null(filters),
    !is.null(pagesize),
    !is.null(page)
  )) {
    query <- build_search_query(
      fields = fields,
      filters = filters,
      pagesize = pagesize,
      page = page
    )
  }

  res <- dkan_GET(url = url, query = query, credentials = credentials, ...)
  switch(as, json = res, list = as_dk(jsl(res), "dkan_list"), df = jsldf(res))
}
