% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_pairs.R
\name{make_pairs}
\alias{make_pairs}
\alias{make_pairs_wf_source}
\title{Record-pair combination.}
\usage{
make_pairs(
  x,
  strata = NULL,
  repeats_allowed = TRUE,
  permutations_allowed = FALSE
)

make_pairs_wf_source(..., data_source = NULL)
}
\arguments{
\item{x}{\code{[atomic]}.}

\item{strata}{Subsets of \code{x}. A blocking attribute limiting the combinations created.}

\item{repeats_allowed}{\code{[logical]} If \code{TRUE}, repetitions are included.}

\item{permutations_allowed}{\code{[logical]} If \code{TRUE}, permutations are included.}

\item{...}{Arguments passed to \code{\link{make_pairs}}.}

\item{data_source}{\code{[character]}. Data source identifier. Limits to record-pairs to those from different sources.}
}
\value{
A \code{list} of indexes and values of record-pair combinations
}
\description{
Create record-pair combination of a vector's elements.
}
\examples{
make_pairs(month.abb[1:4])
make_pairs(month.abb[1:4], strata = c(1, 1, 2, 2))

}
\seealso{
\code{\link{eval_sub_criteria}}
}
