% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dd_isolation.R
\name{ds_dd_isolation}
\alias{ds_dd_isolation}
\alias{dd_isolation}
\title{Compute Distance Decay Isolation}
\usage{
ds_dd_isolation(.data, .cols, .name, .comp = FALSE)

dd_isolation(..., .data = dplyr::cur_data_all())
}
\arguments{
\item{.data}{\link[tibble:tibble-package]{tibble} with sf geometry}

\item{.cols}{\href{https://tidyselect.r-lib.org/reference/language.html}{\code{tidy-select}}
Columns to compute the measure with. Must be at least 2 columns. If more than 2, treats
first column as first group and sum of other columns as second.}

\item{.name}{name for column with distance decay isolation. Leave missing to return a vector.}

\item{.comp}{Default is FALSE. FALSE returns the sum, TRUE returns the components.}

\item{...}{arguments to forward to ds_dd_isolation from dd_isolation}
}
\value{
a \link[tibble:tibble-package]{tibble} or numeric vector if .name missing
}
\description{
Compute Distance Decay Isolation
}
\examples{
data("de_county")
ds_dd_isolation(de_county, c(pop_black, starts_with('pop_')))
ds_dd_isolation(de_county, c(pop_black, starts_with('pop_')), 'dd_isolation')
}
\concept{clustering}
