% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abd_freq_count.R
\name{abd_freq_count}
\alias{abd_freq_count}
\title{Abundance Frequency Count of a Community}
\usage{
abd_freq_count(
  abd,
  level = NULL,
  probability_estimator = c("naive", "Chao2013", "Chao2015", "ChaoShen"),
  unveiling = c("none", "uniform", "geometric"),
  richness_estimator = c("jackknife", "iChao1", "Chao1", "rarefy", "naive"),
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  check_arguments = TRUE
)
}
\arguments{
\item{abd}{A numeric vector containing species abundances.}

\item{level}{The level of interpolation or extrapolation.
It may be a sample size (an integer) or a sample coverage
(a number between 0 and 1).
If not \code{NULL}, the asymptotic \code{estimator} is ignored.}

\item{probability_estimator}{A string containing one of the possible estimators
of the probability distribution (see \link{probabilities}).
Used only for extrapolation.}

\item{unveiling}{A string containing one of the possible unveiling methods
to estimate the probabilities of the unobserved species (see \link{probabilities}).
Used only for extrapolation.}

\item{richness_estimator}{A string containing an estimator recognized by
\link{div_richness} to evaluate the total number of species in \link{probabilities}.
Used only for extrapolation.}

\item{coverage_estimator}{An estimator of sample coverage used by \link{coverage}.}

\item{check_arguments}{If \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}
}
\value{
A two-column tibble. The first column contains the number of observations,
the second one the number of species observed this number of times.
}
\description{
Count the number of species observed the same number of times.
}
\details{
The Abundance Frequency Count \insertCite{Chao2015}{divent} is the number
of species observed each number of times.
It is a way to summarize the species distribution.

It can be estimated at a specified level of interpolation or extrapolation.
Extrapolation relies on the estimation of the estimation of the asymptotic
distribution of the community by \link{probabilities} and eq. (5)
of \insertCite{Chao2014}{divent}.
}
\examples{
abd_freq_count(paracou_6_abd[1, -(1:2)])
}
