% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fadLad.R
\name{fadlad}
\alias{fadlad}
\title{FAD - LAD matrix from occurrence data}
\usage{
fadlad(
  x,
  tax,
  bin = NULL,
  age = NULL,
  revtime = FALSE,
  na.rm = TRUE,
  diffbin = TRUE
)
}
\arguments{
\item{x}{\code{(data.frame)}: Occurrence data.}

\item{tax}{\code{(character)}: Column name of taxon names.}

\item{bin}{\code{(character)}: Column name(s) of the discreet bin variable(s). If two column names are entered, then they will interpreted as minimum and maximum uncertainty (see examples) By default, time flows from lower to higher numbers. You can change this behavior by setting \code{revtime=FALSE}. Either a \code{bin} or \code{age} argument is mandatory.}

\item{age}{\code{(character)}: Column name(s) of the continuous age variable(s). If two column names are entered, then they will interpreted as the minimum and maximum age uncertainty. (see examples) By default, time flows from higher to lower numbers. You can change this behavior by setting \code{revtime=FALSE}. Either a \code{bin} or \code{age} argument is mandatory.}

\item{revtime}{\code{(logical)}: Should time be reversed?}

\item{na.rm}{\code{(logical)}: Should taxa that have no valid FADs or LADs (due to \code{NA} entries) be removed from the output?}

\item{diffbin}{\code{(logical)}: Difference-based duration for discreet time (only applicabble to cases when \code{bin} is provided). If set to \code{TRUE}, single-interval taxa will \code{0} durations. Setting this argument to \code{FALSE} will add code{1} to the durations of all taxa.}
}
\value{
A data.frame, with rows corresponding to \code{tax} entries.
}
\description{
Function to generate range data from an occurrence dataset.
}
\details{
The function will output First and Last Appearance Dates of the taxa in the dataset. Keep in mind that incomplete sampling will influence these data and will make the ranges appear shrunken.

The following variables are produced:

\code{row.names} attribute: The names of the taxa.

\code{FAD}: First appearance dates in time bin nmbers or ages.

\code{LAD}: Last appearance dates in time bin numbers or ages.

\code{duration}: The durations of taxa in bin numbers or ages.
}
\examples{
data(corals)

# binned data
  flBinned <- fadlad(corals, tax="genus", bin="stg")

# using basic bin lengths
  flDual <- fadlad(corals, tax="genus", age=c("max_ma", "min_ma"))

# single age esimate 
  data(stages)
  corals$mid <- stages$mid[corals$stg]
  flSingle <- fadlad(corals, tax="genus", age="mid")


}
