% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distrr_funs.R
\name{only_joint}
\alias{only_joint}
\title{Keeps only joint distribution (removes '.total').}
\usage{
only_joint(.cube, .total = "Totale", .variables = NULL)
}
\arguments{
\item{.cube}{a datacube with 'Totale' modalities}

\item{.total}{modality to eliminate (filter out) (default: "Totale")}

\item{.variables}{a character vector with the names of the categorical variables}
}
\value{
a subset of the data cube with only the combinations of all variables modalities, without the "margins".
}
\description{
Removes all the rows where variables have value \code{.total}.
}
\examples{
data(invented_wages)
str(invented_wages)

vars <- c("gender", "education")
tmp <- dcc2(.data = invented_wages, 
            .variables = vars, 
            .fun = jointfun_, 
            order_type = extract_unique2)
tmp
str(tmp)
only_joint(tmp, .variables = vars)

# Compare dimensions (number of groups)
dim(tmp)
dim(only_joint(tmp, .variables = vars))
}
