% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{support}
\alias{support}
\title{Return the support of a distribution}
\usage{
support(d, drop = TRUE, ...)
}
\arguments{
\item{d}{An object. The package provides methods for distribution
objects such as those from \code{\link[=Normal]{Normal()}} or \code{\link[=Binomial]{Binomial()}} etc.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{...}{Arguments passed to methods. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector (or matrix) with two elements (or columns) indicating the
range (minimum and maximum) of the support.
}
\description{
Generic function for computing the support interval (minimum and maximum)
for a given probability distribution object.
}
\examples{
X <- Normal()
support(X)
Y <- Uniform(-1, 1:3)
support(Y)
}
