% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dist.R
\name{plot_dist}
\alias{plot_dist}
\title{Plot predicted distributional regression models}
\usage{
plot_dist(model, pred_params, palette = "viridis", type = "pdf",
  rug = FALSE)
}
\arguments{
\item{model}{A fitted bamlss object.}

\item{pred_params}{A data.frame with rows for every model prediction and
columns for every predicted parameter of the distribution. Is easily obtained
with the \code{distreg.vis} function \code{\link{preds}}.}

\item{palette}{The colour palette used for colouring the plot. You can use
any of the ones supplied in \code{\link[ggplot2]{scale_fill_brewer}} though I
suggest you use one of the qualitative ones: Accent, Dark2, etc. Since 0.5.0
\code{"viridis"} is included, to account for colour blindness.}

\item{type}{Do you want the probability distribution function ("pdf") or
the cumulative distribution function ("cdf")?}

\item{rug}{If TRUE, creates a rug plot}
}
\value{
A ggplot2 object.
}
\description{
This function plots the parameters of a predicted distribution (e.g. obtained
through \code{\link{preds}}) with ggplot2. You can use all implemented
families in bamlss except the cox family.
}
\examples{
# Generating data
data_fam <- model_fam_data(fam_name = "BE")
# Fit model
library("gamlss")
beta_model <- gamlss(BE ~ norm2 + binomial1,
  data = data_fam, family = BE())
# Get 3 predictions
pred_df <- data_fam[sample(1:nrow(data_fam), 3), c("norm2", "binomial1")]
param_preds <- preds(beta_model, pred_df)
# Create pdf, cdf plots
plot_dist(beta_model, param_preds, rug = TRUE)
}
