% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.Distribution.R
\name{as.Distribution}
\alias{as.Distribution}
\alias{as.Distribution.matrix}
\title{Coerce matrix to vector of WeightedDiscrete}
\usage{
as.Distribution(obj, fun, decorators = NULL)

\method{as.Distribution}{matrix}(obj, fun, decorators = NULL)
}
\arguments{
\item{obj}{\link{matrix}. Column names correspond to \code{x} in \link{WeightedDiscrete},
so this method only works if all distributions (rows in the matrix) have the
same points to be evaluated on. Elements correspond to either the pdf
or cdf of the distribution (see below).}

\item{fun}{Either \code{"pdf"} or \code{"cdf"}, passed to \link{WeightedDiscrete} and tells
the constructor if the elements in \code{obj} correspond to the pdf or cdf of
the distribution.}

\item{decorators}{Passed to \link{VectorDistribution}.}
}
\value{
A \link{VectorDistribution}
}
\description{
Coerces matrices to a \link{VectorDistribution} containing
\link{WeightedDiscrete} distributions. Number of distributions are the number
of rows in the matrix, number of \code{x} points are number of columns in the
matrix.
}
\examples{
pdf <- runif(200)
mat <- matrix(pdf, 20, 10)
mat <- t(apply(mat, 1, function(x) x / sum(x)))
colnames(mat) <- 1:10
as.Distribution(mat, fun = "pdf")
}
