% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distdichoi.R
\name{distdichoi}
\alias{distdichoi}
\title{nomal data (immdediate form, allowing unequal variances)}
\usage{
distdichoi(n1, m1, s1, n2, m2, s2, cp = 0, tail = c("lower", "upper"),
  R = 1, conf.level = 0.95)
}
\arguments{
\item{n1}{A number specifying the number of observations in the exposed group.}

\item{m1}{A number specifying the mean of the exposed group.}

\item{s1}{A number specifying the standard deviation of the exposed group.}

\item{n2}{A number specifying the number of observations in the unexposed (reference) group}

\item{m2}{A number specifying the mean of the unexposed (reference) group.}

\item{s2}{A number specifying the standard deviation of the unexposed (reference) group.}

\item{cp}{A numeric value specifying the cut point under or over which the distributional proportions are computed.}

\item{tail}{A character string specifying the tail of the distribution in which the proportions are computed.
Must be either 'lower' (default) or 'upper'.}

\item{R}{A numeric value indicating the true ratio of variances (R = Var(group1)/Var(group2).
A value of 0 specifies that the true ratio of variances is unknown.}

\item{conf.level}{Confidence level of the interval.}
}
\value{
A list with class 'distdicho' containing the following components:
\item{data.name}{The names of the data.}
\item{arguments}{A list with the specified arguments.}
\item{parameter}{The mean, standard error and number of observations for both groups.}
\item{prop}{The estimated proportions below / above the cut point for both groups.}
\item{dist.estimates}{The difference in proportions, risk ratio and odds ratio of the groups.}
\item{se}{The estimated standard error of the difference in proportions, the risk ratio and the odds ratio.}
\item{ci}{The confidence intervals of the difference in proportions, the risk ratio and the odds ratio.}
\item{method}{A character string indicating the used method.}
\item{ttest}{A list containing the results of a t-test.}
}
\description{
Immediate form of the distributional method for dichotomising normal data
allowing for assumptions of unequal variances
(based on Sauzet et al. 2014 and Peacock et al. 2012).
}
\details{
distdichoi takes no data, but the number of observations as well as the mean and standard deviations of both groups.
It first returns the results of a two-group unpaired t-test (allowing for unequal variances in the unequal variance cases).
Followed by the distributional estimates and their standard errors (see Sauzet et al. 2014 and Peacock et al. 2012)
for a difference in proportions, risk ratio and odds ratio. It also provides the distributional confidence intervals for the statistics estimated
(this assumes an asymptotic normal distribution of estimates and might not be valid for small sample sizes (see Sauzet et al. 2014 for details)).
Estimates are calculated using either assumption of equal variances in both groups (default R = 1) or assumption of
unequal variance ratio (R != 1 & R !=0 for known variance ratio and R=0 for correction for unknown variance ratio).
}
\examples{
# Immediate form of distdicho
distdichoi(n1 = 494, m1 = 3267.4, s1 = 441.3,
           n2 = 983, m2 = 3452, s2 = 435.9,
           cp = 2500, tail = 'upper')

## Proportions of low birth weight babies among smoking and non-smoking mothers
## (data from Peacock et al. 1995). Returns distributional estimates, standard 
## errors and distributional confidence intervals for differences in proportions,
## RR and OR of babies having a birth weight under 2500g (low birth weight LBW)
## for group smoker (mother smokes) over the odds of LBW in group non-smoker 
## (mother doesn't smoke)
# distdicho and distdichoi are returning the same results
bw_smoker <- bwsmoke$birthwt[bwsmoke$smoke == 'smoker']
bw_nonsmoker <- bwsmoke$birthwt[bwsmoke$smoke == 'non-smoker']
distdicho(x = bw_smoker, y = bw_nonsmoker, cp = 2500)
distdichoi(n1 = length(bw_smoker[!is.na(bw_smoker)]), 
           m1 = mean(bw_smoker, na.rm = TRUE), 
           s1 = sd(bw_smoker, na.rm = TRUE),
           n2 = length(bw_nonsmoker[!is.na(bw_smoker)]), 
           m2 = mean(bw_nonsmoker, na.rm = TRUE), 
           s2 = sd(bw_nonsmoker, na.rm = TRUE), 
           cp = 2500)

}
\references{
Peacock J.L., Sauzet O., Ewings S.M., Kerry S.M. Dichotomising continuous data while retaining statistical power using a distributional approach.  Statist. Med; 2012;26:3089-3103.
Sauzet, O., Peacock, J. L. Estimating dichotomised outcomes in two groups with unequal variances: a distributional approach.  Statist. Med; 2014 33 4547-4559 ;DOI: 10.1002/sim.6255.
Peacock, J.L., Bland, J.M., Anderson, H.R.: Preterm delivery: effects of socioeconomic factors, psychological stress, smoking, alcohol, and caffeine. BMJ 311(7004), 531-535 (1995).
}
\seealso{
\code{\link[distdichoR]{distdicho}}, \code{\link[distdichoR]{distdichogen}}, \code{\link[distdichoR]{distdichoigen}}, \code{\link[distdichoR]{regdistdicho}}
}
