% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull-quantile.R
\name{qtailw}
\alias{qtailw}
\title{Quantile function}
\usage{
qtailw(p, threshold, scale, shape)
}
\arguments{
\item{p}{Probability.}

\item{threshold}{Minimum value of the tail.}

\item{scale}{Scale parameter.}

\item{shape}{Shape parameter.}
}
\value{
Gives the quantiles of the TailW. The length of the result is determined by the length of x.
}
\description{
This function computes the quantile function of the tailW.
\deqn{Q(p,\alpha, \beta, \nu) = \left(\frac{-\log(1 - p)}{\alpha} + \nu^\beta\right)^{1 / \beta}}
}
\examples{
qtailw(0.5, 1, 1, 1)
}
\keyword{TailW}
