% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissever.R
\docType{methods}
\name{generate_ci}
\alias{generate_ci}
\alias{generate_ci,list,RasterStack-method}
\title{Confidence intervals using bootstraping}
\usage{
\S4method{generate_ci}{list,RasterStack}(object, covariates, level = 0.9,
  n = 50L)
}
\arguments{
\item{object}{object of class \code{dissever}, output from the \code{dissever} function}

\item{covariates}{object of class \code{"RasterStack"}, the fine-resolution stack of predictive covariates used to generate the dissever output}

\item{level}{If this is a numeric value, it is used to derive confidence intervals using quantiles. If it is a function, it is used to derive the uncertainty using this function.}

\item{n}{the number of bootstrap replicates used to derive the confidence intervals}
}
\description{
Generates confidence intervals of a dissever output using bootstraping
}
\examples{
# Load the Edgeroi dataset (see ?edgeroi)
data(edgeroi)

# Create a dissever output
diss <- dissever(
  coarse = edgeroi$carbon,
  fine = edgeroi$predictors,
  method = "lm",
  min_iter = 5, max_iter = 10,
  p = 0.05
)

# Generate the confidence intervals
\dontrun{
ci <- generate_ci(diss, edgeroi$predictors, n = 5)

plot(ci)
}
}
\author{
Pierre Roudier
}
