% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dip1}
\alias{dip1}
\title{Dissolution data of a reference and a test batch}
\format{
A data frame with 12 observations and 10 variables:
\describe{
  \item{type}{Factor with levels \code{R} (Reference) and \code{T} (Test)}
  \item{tablet}{Factor with levels \code{1} to \code{6} representing
    individual tablets}
  \item{t.5}{Numeric of the \% release at the 5 minutes testing point}
  \item{t.10}{Numeric of the \% release at the 10 minutes testing point}
  \item{t.15}{Numeric of the \% release at the 15 minutes testing point}
  \item{t.20}{Numeric of the \% release at the 20 minutes testing point}
  \item{t.30}{Numeric of the \% release at the 30 minutes testing point}
  \item{t.60}{Numeric of the \% release at the 60 minutes testing point}
  \item{t.90}{Numeric of the \% release at the 90 minutes testing point}
  \item{t.120}{Numeric of the \% release at the 120 minutes testing point}
}
}
\source{
See reference: Example data set shown in Table 1.
}
\usage{
data(dip1)
}
\description{
A data set containing the dissolution data of one reference batch and one
  test batch of \eqn{n = 6} tablets each, i.e. the dissolution profiles of
  the \% drug release observed within a period of 120 minutes.
}
\examples{
str(dip1)
}
\references{
Tsong, Y., Hammerstrom, T., Sathe, P.M., and Shah, V.P. Statistical
assessment of mean differences between two dissolution data sets.
\emph{Drug Inf J}. 1996; \strong{30}: 1105-1112.\cr
\doi{10.1177/009286159603000427}
}
\keyword{datasets}
