% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.dispRity.R
\name{summary.dispRity}
\alias{summary.dispRity}
\title{dispRity object summary}
\usage{
\method{summary}{dispRity}(
  object,
  ...,
  quantiles = c(50, 95),
  cent.tend = median,
  recall = FALSE,
  digits
)
}
\arguments{
\item{object}{A \code{dispRity} object.}

\item{...}{Additional arguments to be passed to \code{\link{summary}} or \code{cent.tend}.}

\item{quantiles}{The quantiles to display (default is \code{quantiles = c(50, 95)}; is ignored if the \code{dispRity} object is not bootstrapped).}

\item{cent.tend}{A function for summarising the bootstrapped disparity values (default is \code{\link[stats]{median}}).}

\item{recall}{\code{logical} value specifying whether to recall the \code{dispRity} parameters input (default = \code{FALSE}).}

\item{digits}{Optional, a value for digits the values in the output table (default = 2).}
}
\value{
A \code{data.frame} with:
\item{subsets}{the subset names.}
\item{n}{the maximum number of elements in each subset (see details).}
\item{observed}{the observed disparity or the the observed central tendency (<cent_tend>) of disparity (\code{obs.<cent_tend>}).}
\item{bootstraps...}{if \code{data} is bootstrapped, the bootstrapped disparity's central tendency (\code{bs.<cent_tend>}) and the quantiles of the bootstrapped disparities (or, if \code{data} is not bootstrapped but disparity is calculated as a distribution - see \code{\link[dispRity]{dispRity}}) - the quantiles of the observed disparity are displayed).}
}
\description{
Creates a summary of a \code{dispRity} object.
}
\details{
If the \code{dispRity} object to summarise comes from a \code{\link[dispRity]{chrono.subsets}} using a \code{"multiPhylo"} object, the displayed number of observations (\code{n}) corresponds to the maximum number of observation at the specific time slice (some slices through some trees might have less observations).
}
\examples{
## Load the disparity data based on Beck & Lee 2014
data(disparity)

## Summarising the results
summary(disparity) # default
## Using different options
summary(disparity, quantiles = 75, cent.tend = mean, digits = 8,
     recall = TRUE)

}
\seealso{
\code{\link{dispRity}}, \code{\link{plot.dispRity}}.
}
\author{
Thomas Guillerme
}
