% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_disk.frame.r
\name{write_disk.frame}
\alias{write_disk.frame}
\alias{output_disk.frame}
\title{Write disk.frame to disk}
\usage{
write_disk.frame(df, outdir = tempfile(fileext = ".df"),
  nchunks = ifelse("disk.frame" \%in\% class(df), nchunks.disk.frame(df),
  recommend_nchunks(df)), overwrite = FALSE, shardby = NULL,
  compress = 50, shardby_function = "hash", sort_splits = NULL,
  desc_vars = NULL, ...)

output_disk.frame(...)
}
\arguments{
\item{df}{a disk.frame}

\item{outdir}{output directory for the disk.frame}

\item{nchunks}{number of chunks}

\item{overwrite}{overwrite output directory}

\item{shardby}{the columns to shard by}

\item{compress}{compression ratio for fst files}

\item{shardby_function}{splitting of chunks: "hash" for hash function or "sort" for semi-sorted chunks}

\item{sort_splits}{for the "sort" shardby function, a dataframe with the split values.}

\item{desc_vars}{for the "sort" shardby function, the variables to sort descending.}

\item{...}{passed to map.disk.frame}
}
\description{
Write a data.frame/disk.frame to a disk.frame location. If df is a data.frame
then using the as.disk.frame function is recommended for most cases
}
\examples{
cars.df = as.disk.frame(cars)

# write out a lazy disk.frame to disk
cars2.df = write_disk.frame(map(cars.df, ~.x[1,]), overwrite = TRUE)
collect(cars2.df)

# clean up cars.df
delete(cars.df)
delete(cars2.df)
}
