% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in.R
\name{distance}
\alias{distance}
\title{Distance computation for disaggregations}
\usage{
distance(x, p = 2)
}
\arguments{
\item{x}{an object of class \code{tscomparison}}

\item{p}{an integer greater than 1L, or Inf.}
}
\value{
a numeric of length 1, the distance.
}
\description{
This function \code{distance} computes the Minkowski distance of exponent p,
related to a tscomparison object, produced with \code{in_sample}, \code{in_disaggr} or
\code{in_revisions}
}
\details{
The meaning depends on the tscomparison function :
\itemize{
\item \code{in_sample} will produce the low-frequency distance between the predicted
value and the response, on the coefficient calculation window.
\item \code{in_disaggr} will produce the high-frequency distance between the inputs
(eventually, the sum of its contributions) and the benchmarked series.
\item \code{in_revisions} will produce the high-frequency distance between the two
benchmarked series (contributions distance isn't permitted).
}
}
\examples{
benchmark <- twoStepsBenchmark(turnover,construction,include.rho = TRUE)
distance(in_sample(benchmark,type="changes"))
distance(in_disaggr(benchmark,type="contributions"),p=1L)
distance(in_disaggr(benchmark,type="changes"),p=Inf)
}
\seealso{
in_sample in_disaggr in_revisions
}
