% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metropdir.R
\name{metropdir}
\alias{metropdir}
\title{Directional Metropolis Hastings}
\usage{
metropdir(obj, dobj, initial, lchain, sd.prop = 1, steplen = 0, s = 0.95,
  ...)
}
\arguments{
\item{obj}{an R function that evaluates the log unnormalized probability
density of the desired equilibrium distribution of the Markov chain.
First argument is the state vector of the Markov chain.  Other arguments
arbitrary and taken from the \code{...} arguments of this function.
Should return \code{- Inf} for points of the state space having
probability zero under the desired equilibrium distribution.}

\item{dobj}{an R function that evaluates the derivative of the log unnormalized probability density at the current state of the markov chain.}

\item{initial}{Initial state of the markov chain. \code{obj(state)} must not return #' \code{-Inf}}

\item{lchain}{length of the chain}

\item{sd.prop}{scale to use for the proposal}

\item{steplen}{tuning parameter in mean of proposal}

\item{s}{tuning parameter in the covariance of proposal}

\item{...}{any arguments to be passed to obj and dobj.}
}
\value{
Returns the following objects in a list:
\itemize{
\item accept. acceptance rate.
\item batch. resulting chain.
}
}
\description{
Implements Markov Chain Monte Carlo for continuous random vectors using Directional Metropolis Hasting Algorithm
}
\details{
Runs a \dQuote{Directional Metropolis Hastings} algorithm, with multivariate normal proposal
producing a Markov chain with equilibrium distribution having a specified
unnormalized density.  Distribution must be continuous.  Support of the
distribution is the support of the density specified by argument \code{obj}.
}
\examples{
\dontrun{
Sigma <- matrix(c(1,0.2,0.2,1),2,2)
mu <- c(1,1)
Sig.Inv <- solve(Sigma)
Sig.det.sqrt <- sqrt(det(Sigma))
logf <- function(x,mu,Sig.Inv){
  x.center <- as.numeric((x-mu))
  out <- crossprod(x.center,Sig.Inv)
  out <- sum(out*x.center)
  -out/2
  }

gr.logf <- function(x,mu,Sig.Inv){
  x.center <- as.numeric((x-mu))
  out <- crossprod(x.center,Sig.Inv)
  -as.numeric(out)
}
set.seed(1234)
system.time(out <- metropdir(obj = logf, dobj = gr.logf, initial = c(1,1),
                         lchain = 1e4,sd.prop=1,steplen=0,s=1, mu = mu,
                         Sig.Inv = Sig.Inv))
#acceptance rate
out$accept
#density plot
plot(density(out$batch[,1]))
}
}
\author{
Abhirup Mallik, \email{malli066@umn.edu}
}
\seealso{
\code{\link{metropdir.adapt}} for adapting DMH, \code{\link{iact}} for integrated auto correlation times, \code{\link{mcmcdiag}}, \code{\link{msjd}} for mean squared jump distance.
for summary of diagnostic measures of a chain, \code{\link{multiESS}} for Multivariate effective sample size.
}
\keyword{dmh,}
\keyword{mcmc}

