% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/augment.R, R/tidy.R
\docType{methods}
\name{tidy}
\alias{tidy}
\alias{tidy-method}
\alias{augment}
\alias{augment-method}
\alias{augment,MultivariateAnalysis-method}
\alias{tidy,MultivariateAnalysis-method}
\title{Tidy Coordinates}
\usage{
tidy(x, ...)

augment(x, ...)

\S4method{augment}{MultivariateAnalysis}(x, ..., margin = 1, axes = c(1, 2), principal = TRUE)

\S4method{tidy}{MultivariateAnalysis}(x, ..., margin = 1, principal = TRUE)
}
\arguments{
\item{x}{A \code{\linkS4class{CA}}, \code{\linkS4class{MCA}} or \code{\linkS4class{PCA}} object.}

\item{...}{Currently not used.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript
which the data will be returned: \code{1} indicates individuals/rows (the
default), \code{2} indicates variables/columns.}

\item{axes}{A length-two \code{\link{numeric}} vector giving the dimensions
to be for which to compute results.}

\item{principal}{A \code{\link{logical}} scalar: should principal coordinates be
returned? If \code{FALSE}, standard coordinates are returned.}
}
\value{
\code{tidy()} returns a long \code{\link{data.frame}} with the following columns:
\describe{
\item{\code{label}}{Row/column names of the original data.}
\item{\code{component}}{Component.}
\item{\code{supplementary}}{Whether an observation is active or
supplementary.}
\item{\code{coordinate}}{Coordinates.}
\item{\code{contribution}}{Contributions to the definition of the components.}
\item{\code{cos2}}{\eqn{cos^2}{cos2}.}
}

\code{augment()} returns a wide \code{\link{data.frame}} of the row/column coordinates
along \code{axes} and the following columns:
\describe{
\item{\code{label}}{Row/column names of the original data.}
\item{\code{supplementary}}{Whether an observation is active or
supplementary.}
\item{\code{mass}}{Weight/mass of each observation.}
\item{\code{sum}}{Sum of squared coordinates along \code{axes}.}
\item{\code{contribution}}{Joint contributions to the definition of \code{axes}.}
\item{\code{cos2}}{Joint \eqn{cos^2}{cos2} along \code{axes}.}
}
}
\description{
Tidy Coordinates
}
\examples{
## Load data
data("iris")

## Compute principal components analysis
X <- pca(iris, scale = TRUE, sup_row = 5:10)

## Get row principal coordinates
head(get_coordinates(X, margin = 1, principal = TRUE))

## Get row standard coordinates
head(get_coordinates(X, margin = 1, principal = FALSE))

## Tidy principal coordinates
head(tidy(X, margin = 1))
head(tidy(X, margin = 2))

head(augment(X, margin = 1, axes = c(1, 2)))
head(augment(X, margin = 2, axes = c(1, 2)))
}
\seealso{
Other summary: 
\code{\link{summary}()}
}
\author{
N. Frerebeau
}
\concept{summary}
